"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REFRESH_LABEL = void 0;
exports.RefreshButton = RefreshButton;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _contexts = require("../../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RefreshButton() {
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsRefreshButtonButton",
    iconType: "refresh",
    onClick: () => refreshApp()
  }, REFRESH_LABEL);
}
const REFRESH_LABEL = exports.REFRESH_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.refresh', {
  defaultMessage: 'Refresh'
});