"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TLSRuleComponent = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _alert_tls = require("./alert_tls");
var _settings = require("../../state/settings");
var _constants = require("../../../../../common/constants");
var _query_bar = require("./query_bar");
var _tls_rule_viz = require("./tls_rule_viz");
var _synthetics_data_view_context = require("../../contexts/synthetics_data_view_context");
var _field_filters = require("./common/field_filters");
var _types = require("../monitor_add_edit/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tlsMonitorTypes = [_types.MonitorTypeEnum.HTTP, _types.MonitorTypeEnum.TCP];
const TLSRuleComponent = ({
  ruleParams,
  setRuleParams
}) => {
  var _ruleParams$kqlQuery, _ref, _ruleParams$certAgeTh, _ref2, _ruleParams$certExpir;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    settings
  } = (0, _reactRedux.useSelector)(_settings.selectDynamicSettings);
  (0, _react.useEffect)(() => {
    if (typeof settings === 'undefined') {
      dispatch(_settings.getDynamicSettingsAction.get());
    }
  }, [dispatch, settings]);
  const onFiltersChange = (0, _react.useCallback)(val => {
    setRuleParams('kqlQuery', val.kqlQuery);
  }, [setRuleParams]);
  const dataView = (0, _synthetics_data_view_context.useSyntheticsDataView)();
  const monitorTypeField = dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName('monitor.type');

  // filtersForSuggestions can be applied only if dataView and monitorTypeField are available
  const filtersForSuggestions = dataView && monitorTypeField ? [(0, _esQuery.buildPhrasesFilter)(monitorTypeField, tlsMonitorTypes, dataView)] : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_query_bar.AlertSearchBar, {
    kqlQuery: (_ruleParams$kqlQuery = ruleParams.kqlQuery) !== null && _ruleParams$kqlQuery !== void 0 ? _ruleParams$kqlQuery : '',
    onChange: onFiltersChange,
    filtersForSuggestions: filtersForSuggestions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_field_filters.FieldFilters, {
    ruleParams: ruleParams,
    setRuleParams: setRuleParams,
    filters: {
      monitorTypes: tlsMonitorTypes
    }
  }), /*#__PURE__*/_react.default.createElement(_tls_rule_viz.TLSRuleViz, {
    ruleParams: ruleParams
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_alert_tls.AlertTlsCondition, {
    ageThreshold: (_ref = (_ruleParams$certAgeTh = ruleParams.certAgeThreshold) !== null && _ruleParams$certAgeTh !== void 0 ? _ruleParams$certAgeTh : settings === null || settings === void 0 ? void 0 : settings.certAgeThreshold) !== null && _ref !== void 0 ? _ref : _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold,
    expirationThreshold: (_ref2 = (_ruleParams$certExpir = ruleParams.certExpirationThreshold) !== null && _ruleParams$certExpir !== void 0 ? _ruleParams$certExpir : settings === null || settings === void 0 ? void 0 : settings.certExpirationThreshold) !== null && _ref2 !== void 0 ? _ref2 : _constants.DYNAMIC_SETTINGS_DEFAULTS.certExpirationThreshold,
    setAgeThreshold: value => setRuleParams('certAgeThreshold', Number(value)),
    setExpirationThreshold: value => setRuleParams('certExpirationThreshold', Number(value))
  }));
};
exports.TLSRuleComponent = TLSRuleComponent;