"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusGridComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _utils = require("../common/utils");
var _redux_store = require("./redux_store");
var _show_selected_filters = require("../common/show_selected_filters");
var _state = require("../../synthetics/state");
var _embeddable_panel_wrapper = require("../../synthetics/components/common/components/embeddable_panel_wrapper");
var _synthetics_embeddable_context = require("../synthetics_embeddable_context");
var _overview_grid = require("../../synthetics/components/monitors_page/overview/overview/overview_grid");
var _use_monitors_sorted_by_status = require("../../synthetics/hooks/use_monitors_sorted_by_status");
var _metric_item = require("../../synthetics/components/monitors_page/overview/overview/metric_item/metric_item");
var _monitor_detail_flyout = require("../../synthetics/components/monitors_page/overview/overview/monitor_detail_flyout");
var _use_overview_status = require("../../synthetics/components/monitors_page/hooks/use_overview_status");
var _overview_loader = require("../../synthetics/components/monitors_page/overview/overview/overview_loader");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusGridComponent = ({
  reload$,
  filters,
  view
}) => {
  const overviewStore = (0, _react.useRef)((0, _redux_store.getOverviewStore)());
  const hasFilters = !(0, _utils.areFiltersEmpty)(filters);
  const singleMonitor = filters && filters.locations.length === 1 && filters.monitorIds.length === 1;
  const monitorOverviewListComponent = /*#__PURE__*/_react.default.createElement(_synthetics_embeddable_context.SyntheticsEmbeddableContext, {
    reload$: reload$,
    reduxStore: overviewStore.current
  }, /*#__PURE__*/_react.default.createElement(MonitorsOverviewList, {
    filters: filters,
    singleMonitor: singleMonitor,
    view: view
  }));
  return singleMonitor ? monitorOverviewListComponent : /*#__PURE__*/_react.default.createElement(_embeddable_panel_wrapper.EmbeddablePanelWrapper, {
    titleAppend: hasFilters ? /*#__PURE__*/_react.default.createElement(_show_selected_filters.ShowSelectedFilters, {
      filters: filters !== null && filters !== void 0 ? filters : {}
    }) : null
  }, monitorOverviewListComponent);
};
exports.StatusGridComponent = StatusGridComponent;
const SingleMonitorView = () => {
  const trendData = (0, _reactRedux.useSelector)(_state.selectOverviewTrends);
  const dispatch = (0, _reactRedux.useDispatch)();
  const setFlyoutConfigCallback = (0, _react.useCallback)(params => {
    dispatch((0, _state.setFlyoutConfig)(params));
  }, [dispatch]);
  const {
    loaded
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const monitorsSortedByStatus = (0, _use_monitors_sorted_by_status.useMonitorsSortedByStatus)();
  if (loaded && monitorsSortedByStatus.length !== 1) {
    throw new Error('One and only one monitor should always be returned by useMonitorsSortedByStatus in this component, this should never happen');
  }
  const monitor = monitorsSortedByStatus.length === 1 ? monitorsSortedByStatus[0] : undefined;
  (0, _react.useEffect)(() => {
    if (monitor && !trendData[monitor.configId + monitor.locationId]) {
      dispatch(_state.trendStatsBatch.get([{
        configId: monitor.configId,
        locationId: monitor.locationId,
        schedule: monitor.schedule
      }]));
    }
  }, [dispatch, monitor, trendData]);
  const style = {
    height: '100%'
  };
  if (!monitor) return /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, {
    rows: 1,
    columns: 1,
    style: style
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    monitor: monitor,
    onClick: setFlyoutConfigCallback,
    style: style
  }), /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.MaybeMonitorDetailsFlyout, {
    setFlyoutConfigCallback: setFlyoutConfigCallback
  }));
};
const MonitorsOverviewList = ({
  filters,
  singleMonitor,
  view
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    if (!filters) return;
    dispatch((0, _state.setOverviewPageStateAction)({
      tags: filters.tags.map(tag => tag.value),
      locations: filters.locations.map(location => location.value),
      monitorTypes: filters.monitorTypes.map(monitorType => monitorType.value),
      monitorQueryIds: filters.monitorIds.map(monitorId => monitorId.value),
      projects: filters.projects.map(project => project.value)
    }));
  }, [dispatch, filters]);
  if (singleMonitor && view === 'cardView') {
    return /*#__PURE__*/_react.default.createElement(SingleMonitorView, null);
  }
  return /*#__PURE__*/_react.default.createElement(_overview_grid.OverviewGrid, {
    view: view,
    isEmbeddable: true
  });
};