"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerificationModeCodec = exports.VerificationMode = exports.TLSVersionCodec = exports.TLSVersion = exports.SourceTypeCodec = exports.SourceType = exports.ScreenshotOptionCodec = exports.ScreenshotOption = exports.ScheduleUnitCodec = exports.ScheduleUnit = exports.ResponseCheckJSONCodec = exports.ResponseBodyIndexPolicyCodec = exports.ResponseBodyIndexPolicy = exports.RequestBodyCheckCodec = exports.MonitorTypeEnum = exports.MonitorTypeCodec = exports.MonacoEditorLangId = exports.ModeCodec = exports.Mode = exports.HTTPMethod = exports.FormMonitorTypeCodec = exports.FormMonitorType = exports.ContentType = exports.CodeEditorModeCodec = exports.CodeEditorMode = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _t_enum = require("../../utils/t_enum");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MonitorTypeEnum = exports.MonitorTypeEnum = /*#__PURE__*/function (MonitorTypeEnum) {
  MonitorTypeEnum["HTTP"] = "http";
  MonitorTypeEnum["TCP"] = "tcp";
  MonitorTypeEnum["ICMP"] = "icmp";
  MonitorTypeEnum["BROWSER"] = "browser";
  return MonitorTypeEnum;
}({});
const MonitorTypeCodec = exports.MonitorTypeCodec = (0, _t_enum.tEnum)('type', MonitorTypeEnum);
let HTTPMethod = exports.HTTPMethod = /*#__PURE__*/function (HTTPMethod) {
  HTTPMethod["GET"] = "GET";
  HTTPMethod["POST"] = "POST";
  HTTPMethod["PUT"] = "PUT";
  HTTPMethod["DELETE"] = "DELETE";
  HTTPMethod["HEAD"] = "HEAD";
  return HTTPMethod;
}({});
let ResponseBodyIndexPolicy = exports.ResponseBodyIndexPolicy = /*#__PURE__*/function (ResponseBodyIndexPolicy) {
  ResponseBodyIndexPolicy["ALWAYS"] = "always";
  ResponseBodyIndexPolicy["NEVER"] = "never";
  ResponseBodyIndexPolicy["ON_ERROR"] = "on_error";
  return ResponseBodyIndexPolicy;
}({});
const ResponseBodyIndexPolicyCodec = exports.ResponseBodyIndexPolicyCodec = (0, _t_enum.tEnum)('ResponseBodyIndexPolicy', ResponseBodyIndexPolicy);
let MonacoEditorLangId = exports.MonacoEditorLangId = /*#__PURE__*/function (MonacoEditorLangId) {
  MonacoEditorLangId["JSON"] = "xjson";
  MonacoEditorLangId["PLAINTEXT"] = "plaintext";
  MonacoEditorLangId["XML"] = "xml";
  MonacoEditorLangId["JAVASCRIPT"] = "javascript";
  return MonacoEditorLangId;
}({});
let CodeEditorMode = exports.CodeEditorMode = /*#__PURE__*/function (CodeEditorMode) {
  CodeEditorMode["FORM"] = "form";
  CodeEditorMode["JSON"] = "json";
  CodeEditorMode["PLAINTEXT"] = "text";
  CodeEditorMode["XML"] = "xml";
  return CodeEditorMode;
}({});
const CodeEditorModeCodec = exports.CodeEditorModeCodec = (0, _t_enum.tEnum)('CodeEditorMode', CodeEditorMode);
let ContentType = exports.ContentType = /*#__PURE__*/function (ContentType) {
  ContentType["JSON"] = "application/json";
  ContentType["TEXT"] = "text/plain";
  ContentType["XML"] = "application/xml";
  ContentType["FORM"] = "application/x-www-form-urlencoded";
  return ContentType;
}({});
let ScheduleUnit = exports.ScheduleUnit = /*#__PURE__*/function (ScheduleUnit) {
  ScheduleUnit["MINUTES"] = "m";
  ScheduleUnit["SECONDS"] = "s";
  return ScheduleUnit;
}({});
const ScheduleUnitCodec = exports.ScheduleUnitCodec = (0, _t_enum.tEnum)('ScheduleUnit', ScheduleUnit);
let VerificationMode = exports.VerificationMode = /*#__PURE__*/function (VerificationMode) {
  VerificationMode["CERTIFICATE"] = "certificate";
  VerificationMode["FULL"] = "full";
  VerificationMode["NONE"] = "none";
  VerificationMode["STRICT"] = "strict";
  return VerificationMode;
}({});
const VerificationModeCodec = exports.VerificationModeCodec = (0, _t_enum.tEnum)('VerificationMode', VerificationMode);
let TLSVersion = exports.TLSVersion = /*#__PURE__*/function (TLSVersion) {
  TLSVersion["ONE_ZERO"] = "TLSv1.0";
  TLSVersion["ONE_ONE"] = "TLSv1.1";
  TLSVersion["ONE_TWO"] = "TLSv1.2";
  TLSVersion["ONE_THREE"] = "TLSv1.3";
  return TLSVersion;
}({});
const TLSVersionCodec = exports.TLSVersionCodec = (0, _t_enum.tEnum)('TLSVersion', TLSVersion);
let ScreenshotOption = exports.ScreenshotOption = /*#__PURE__*/function (ScreenshotOption) {
  ScreenshotOption["ON"] = "on";
  ScreenshotOption["OFF"] = "off";
  ScreenshotOption["ONLY_ON_FAILURE"] = "only-on-failure";
  return ScreenshotOption;
}({});
const ScreenshotOptionCodec = exports.ScreenshotOptionCodec = (0, _t_enum.tEnum)('ScreenshotOption', ScreenshotOption);
let SourceType = exports.SourceType = /*#__PURE__*/function (SourceType) {
  SourceType["UI"] = "ui";
  SourceType["PROJECT"] = "project";
  return SourceType;
}({});
const SourceTypeCodec = exports.SourceTypeCodec = (0, _t_enum.tEnum)('SourceType', SourceType);
let FormMonitorType = exports.FormMonitorType = /*#__PURE__*/function (FormMonitorType) {
  FormMonitorType["SINGLE"] = "single";
  FormMonitorType["MULTISTEP"] = "multistep";
  FormMonitorType["HTTP"] = "http";
  FormMonitorType["TCP"] = "tcp";
  FormMonitorType["ICMP"] = "icmp";
  return FormMonitorType;
}({});
const FormMonitorTypeCodec = exports.FormMonitorTypeCodec = (0, _t_enum.tEnum)('FormMonitorType', FormMonitorType);
let Mode = exports.Mode = /*#__PURE__*/function (Mode) {
  Mode["ANY"] = "any";
  Mode["ALL"] = "all";
  return Mode;
}({});
const ModeCodec = exports.ModeCodec = (0, _t_enum.tEnum)('Mode', Mode);
const ResponseCheckJSONCodec = exports.ResponseCheckJSONCodec = t.interface({
  description: t.string,
  expression: t.string
});
const RequestBodyCheckCodec = exports.RequestBodyCheckCodec = t.interface({
  value: t.string,
  type: CodeEditorModeCodec
});