"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamFromDefinition = streamFromDefinition;
var _streamsSchema = require("@kbn/streams-schema");
var _unwired_stream = require("../streams/unwired_stream");
var _wired_stream = require("../streams/wired_stream");
var _group_stream = require("../streams/group_stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This should be the only thing that knows about the various stream types
function streamFromDefinition(definition, dependencies) {
  if (_streamsSchema.Streams.WiredStream.Definition.is(definition)) {
    return new _wired_stream.WiredStream(definition, dependencies);
  } else if (_streamsSchema.Streams.UnwiredStream.Definition.is(definition)) {
    return new _unwired_stream.UnwiredStream(definition, dependencies);
  } else if (_streamsSchema.Streams.GroupStream.Definition.is(definition)) {
    return new _group_stream.GroupStream(definition, dependencies);
  }
  throw new Error('Unsupported stream type');
}