"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_PRIORITY = void 0;
exports.generateIndexTemplate = generateIndexTemplate;
var _streamsSchema = require("@kbn/streams-schema");
var _constants = require("../../../../common/constants");
var _name = require("../ingest_pipelines/name");
var _name2 = require("./name");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Max java long value.
// We create the stream index template with the max priority possible
// to guarantee it will take precedence over existing templates overlapping
// with the index pattern.
const MAX_PRIORITY = exports.MAX_PRIORITY = 9223372036854775807n;
function generateIndexTemplate(name) {
  const composedOf = (0, _streamsSchema.getAncestorsAndSelf)(name).reduce((acc, ancestorName) => {
    return [...acc, `${ancestorName}@stream.layer`];
  }, []);
  return {
    name: (0, _name2.getIndexTemplateName)(name),
    index_patterns: [name],
    composed_of: composedOf,
    // max priority passed as a string so we don't lose precision
    priority: `${MAX_PRIORITY}`,
    version: _constants.ASSET_VERSION,
    _meta: {
      managed: true,
      description: `The index template for ${name} stream`
    },
    data_stream: {
      hidden: false,
      failure_store: false
    },
    template: {
      settings: {
        index: {
          default_pipeline: (0, _name.getProcessingPipelineName)(name)
        }
      },
      mappings: {
        properties: {
          'stream.name': {
            type: 'constant_keyword',
            value: name
          }
        }
      }
    },
    allow_auto_create: true,
    // ignore missing component templates to be more robust against out-of-order syncs
    ignore_missing_component_templates: composedOf
  };
}