"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteComponent = deleteComponent;
exports.upsertComponent = upsertComponent;
var _retry = require("../helpers/retry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteComponent({
  esClient,
  name,
  logger
}) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.cluster.deleteComponentTemplate({
      name
    }, {
      ignore: [404]
    }), {
      logger
    });
  } catch (error) {
    logger.error(`Error deleting component template: ${error.message}`);
    throw error;
  }
}
async function upsertComponent({
  esClient,
  component,
  logger
}) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.cluster.putComponentTemplate(component), {
      logger
    });
    logger.debug(() => `Installed component template: ${JSON.stringify(component)}`);
  } catch (error) {
    logger.error(`Error updating component template: ${error.message}`);
    throw error;
  }
}