"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDebounced = useDebounced;
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDebounced(value, debounceDelay = 300) {
  const [debouncedValue, setValue] = (0, _react.useState)(value);
  (0, _useDebounce.default)(() => {
    setValue(value);
  }, debounceDelay, [value, setValue]);
  return debouncedValue;
}