"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsTelemetryClient = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StreamsTelemetryClient {
  constructor(analytics) {
    this.analytics = analytics;
  }
  trackAssetCounts(params) {
    this.analytics.reportEvent(_constants.STREAMS_ASSET_COUNT_EVENT_TYPE, params);
  }
  trackAssetClick(params) {
    this.analytics.reportEvent(_constants.STREAMS_ASSET_CLICK_EVENT_TYPE, params);
  }
  startTrackingAIGrokSuggestionLatency(params) {
    const start = Date.now();
    return (count, rates) => {
      this.analytics.reportEvent(_constants.STREAMS_AI_GROK_SUGGESTION_LATENCY_EVENT_TYPE, {
        ...params,
        duration_ms: Date.now() - start,
        suggestion_count: count,
        match_rate: rates
      });
    };
  }
  trackAIGrokSuggestionAccepted(params) {
    this.analytics.reportEvent(_constants.STREAMS_AI_GROK_SUGGESTION_ACCEPTED_EVENT_TYPE, params);
  }
}
exports.StreamsTelemetryClient = StreamsTelemetryClient;