"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverStreamsLink = DiscoverStreamsLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _reactHooks = require("@kbn/react-hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DiscoverStreamsLink(props) {
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: props.coreApplication
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.streams.discoverStreamsLink.title', {
    defaultMessage: 'Stream'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    size: "s",
    label: _i18n.i18n.translate('xpack.streams.betaBadgeLabel', {
      defaultMessage: 'Streams is currently in tech preview'
    }),
    color: "hollow",
    iconType: "beaker"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(DiscoverStreamsLinkContent, props))));
}
function getFallbackStreamName(flattenedDoc) {
  const wiredStreamName = flattenedDoc['stream.name'];
  if (wiredStreamName) {
    return String(wiredStreamName);
  }
  const dsnsType = flattenedDoc['data_stream.type'];
  const dsnsDataset = flattenedDoc['data_stream.dataset'];
  const dsnsNamespace = flattenedDoc['data_stream.namespace'];
  if (dsnsType && dsnsDataset && dsnsNamespace) {
    return `${dsnsType}-${dsnsDataset}-${dsnsNamespace}`;
  }
  return undefined;
}
function DiscoverStreamsLinkContent({
  streamsRepositoryClient,
  doc,
  locator
}) {
  const flattenedDoc = doc.flattened;
  const index = doc.raw._index;
  const fallbackStreamName = getFallbackStreamName(flattenedDoc);
  const {
    value,
    loading,
    error
  } = (0, _reactHooks.useAbortableAsync)(async ({
    signal
  }) => {
    var _definition$stream;
    if (!index) {
      return fallbackStreamName;
    }
    const definition = await streamsRepositoryClient.fetch('GET /internal/streams/_resolve_index', {
      signal,
      params: {
        query: {
          index
        }
      }
    });
    return definition === null || definition === void 0 ? void 0 : (_definition$stream = definition.stream) === null || _definition$stream === void 0 ? void 0 : _definition$stream.name;
  }, [streamsRepositoryClient, index, fallbackStreamName]);
  const params = (0, _react.useMemo)(() => ({
    name: value
  }), [value]);
  const redirectUrl = (0, _react.useMemo)(() => locator.getRedirectUrl(params), [locator, params]);
  const empty = /*#__PURE__*/_react.default.createElement("span", null, "-");
  if (!index && !value) {
    return empty;
  }
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    });
  }
  if (error || !value) {
    return empty;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: redirectUrl
  }, value);
}