"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsTreeTable = StreamsTreeTable;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _utils = require("./utils");
var _streams_app_search_bar = require("../streams_app_search_bar");
var _documents_column = require("./documents_column");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _retention_column = require("./retention_column");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamsTreeTable({
  loading,
  streams
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [sortField, setSortField] = (0, _react.useState)('nameSortKey');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const items = _react.default.useMemo(() => (0, _utils.buildStreamRows)(streams !== null && streams !== void 0 ? streams : [], sortField, sortDirection), [streams, sortField, sortDirection]);
  const onTableChange = (0, _react.useCallback)(({
    sort
  }) => {
    if (sort && (sort.field === 'nameSortKey' || sort.field === 'retentionMs')) {
      setSortField(sort.field);
      setSortDirection(sort.direction);
    }
  }, []);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: loading,
    columns: [{
      field: 'nameSortKey',
      name: _i18n.i18n.translate('xpack.streams.streamsTreeTable.nameColumnName', {
        defaultMessage: 'Name'
      }),
      sortable: row => row.rootNameSortKey,
      dataType: 'string',
      render: (_, item) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        responsive: false,
        className: (0, _css.css)`
                margin-left: ${item.level * parseInt(euiTheme.size.xl, 10)}px;
              `
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, item.children.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "arrowDown",
        color: "text",
        size: "m"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "empty",
        color: "text",
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "streamsAppStreamNodeLink",
        href: router.link('/{key}', {
          path: {
            key: item.name
          }
        })
      }, item.name)))
    }, {
      field: 'documentsCount',
      name: /*#__PURE__*/_react.default.createElement("span", {
        className: (0, _css.css)`
                margin-right: ${euiTheme.size.l};
              `
      }, _i18n.i18n.translate('xpack.streams.streamsTreeTable.documentsColumnName', {
        defaultMessage: 'Documents'
      })),
      width: '280px',
      sortable: false,
      dataType: 'number',
      render: (_, item) => item.data_stream ? /*#__PURE__*/_react.default.createElement(_documents_column.DocumentsColumn, {
        indexPattern: item.name,
        numDataPoints: 25
      }) : null
    }, {
      field: 'retentionMs',
      name: _i18n.i18n.translate('xpack.streams.streamsTreeTable.retentionColumnName', {
        defaultMessage: 'Retention'
      }),
      width: '160px',
      align: 'left',
      sortable: row => row.rootRetentionMs,
      dataType: 'number',
      render: (_, item) => /*#__PURE__*/_react.default.createElement(_retention_column.RetentionColumn, {
        lifecycle: item.effective_lifecycle
      })
    }],
    itemId: "name",
    items: items,
    sorting: sorting,
    message: _i18n.i18n.translate('xpack.streams.streamsTreeTable.noStreamsMessage', {
      defaultMessage: 'Loading streams...'
    }),
    onTableChange: onTableChange,
    pagination: {
      initialPageSize: 25,
      pageSizeOptions: [25, 50, 100]
    },
    search: {
      box: {
        incremental: true
      },
      toolsRight: /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
        showDatePicker: true
      })
    }
  });
}