"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamListView = StreamListView;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_kibana = require("../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../hooks/use_streams_app_fetch");
var _tree_table = require("./tree_table");
var _streams_app_page_template = require("../streams_app_page_template");
var _streams_list_empty_prompt = require("./streams_list_empty_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamListView() {
  var _streamsListFetch$val;
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        },
        share
      }
    },
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const handleAddData = () => {
    onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.navigate({});
  };
  const streamsListFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    const {
      streams
    } = await streamsRepositoryClient.fetch('GET /internal/streams', {
      signal
    });
    return streams;
  }, [streamsRepositoryClient]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    paddingSize: "l",
    css: (0, _react2.css)`
          background: ${euiTheme.colors.backgroundBasePlain};
          .euiSpacer--l {
            display: none !important;
          }
        `,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      css: (0, _react2.css)`
              margin-bottom: ${euiTheme.size.s};
            `
    }, _i18n.i18n.translate('xpack.streams.streamsListView.pageHeaderTitle', {
      defaultMessage: 'Streams'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _i18n.i18n.translate('xpack.streams.streamsListView.betaBadgeLabel', {
        defaultMessage: 'Technical Preview'
      }),
      tooltipContent: _i18n.i18n.translate('xpack.streams.streamsListView.betaBadgeDescription', {
        defaultMessage: 'This functionality is experimental and not supported. It may change or be removed at any time.'
      }),
      alignment: "middle",
      size: "s"
    }))
  }, /*#__PURE__*/_react.default.createElement("p", {
    css: (0, _react2.css)`
            margin: 0 0 ${euiTheme.size.s} 0;
            font-size: ${euiTheme.font.scale.s};
            color: ${euiTheme.colors.textSubdued};
            line-height: ${euiTheme.size.l};
          `
  }, _i18n.i18n.translate('xpack.streams.streamsListView.pageHeaderDescription', {
    defaultMessage: 'Use Streams to organize and process your data into clear structured flows, and simplify routing, field extraction, and retention management.'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: docLinks.links.observability.logsStreams
  }, _i18n.i18n.translate('xpack.streams.streamsListView.pageHeaderDocsLink', {
    defaultMessage: 'See docs'
  })))), /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, {
    grow: true
  }, !streamsListFetch.loading && !((_streamsListFetch$val = streamsListFetch.value) !== null && _streamsListFetch$val !== void 0 && _streamsListFetch$val.length) ? /*#__PURE__*/_react.default.createElement(_streams_list_empty_prompt.StreamsListEmptyPrompt, {
    onAddData: handleAddData
  }) : /*#__PURE__*/_react.default.createElement(_tree_table.StreamsTreeTable, {
    loading: streamsListFetch.loading,
    streams: streamsListFetch.value
  })));
}