"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectCurrentRule = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Selects the set of dotted fields that are not supported by the current simulation.
 */
const selectCurrentRule = exports.selectCurrentRule = (0, _reselect.createSelector)([context => context.routing, context => context.currentRuleId], (routing, currentRuleId) => {
  const currentRoutingRule = routing.find(rule => rule.id === currentRuleId);
  if (!currentRoutingRule) {
    throw new Error('Current routing rule not found');
  }
  return currentRoutingRule;
});