"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatIngestionRate = exports.formatBytes = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatBytes = value => (0, _eui.formatNumber)(value, '0.0 ib');
exports.formatBytes = formatBytes;
const formatIngestionRate = (bytesPerDay, perDayOnly = false) => {
  const perDay = formatBytes(bytesPerDay);
  const perMonth = formatBytes(bytesPerDay * 30);
  if (perDayOnly) return _i18n.i18n.translate('xpack.streams.streamDetailOverview.ingestionRatePerDay', {
    defaultMessage: '{perDay} / Day',
    values: {
      perDay
    }
  });
  return _i18n.i18n.translate('xpack.streams.streamDetailOverview.ingestionRatePerDayPerMonth', {
    defaultMessage: '{perDay} / Day ({perMonth} / Month)',
    values: {
      perDay,
      perMonth
    }
  });
};
exports.formatIngestionRate = formatIngestionRate;