"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSimulationRunFailureNofitier = createSimulationRunFailureNofitier;
exports.createSimulationRunnerActor = createSimulationRunnerActor;
var _i18n = require("@kbn/i18n");
var _xstate = require("xstate5");
var _lodash = require("lodash");
var _utils = require("../../utils");
var _utils2 = require("./utils");
var _utils3 = require("../../../schema_editor/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createSimulationRunnerActor({
  streamsRepositoryClient
}) {
  return (0, _xstate.fromPromise)(({
    input,
    signal
  }) => streamsRepositoryClient.fetch('POST /internal/streams/{name}/processing/_simulate', {
    signal,
    params: {
      path: {
        name: input.streamName
      },
      body: {
        documents: input.documents,
        processing: input.processors.map(_utils.processorConverter.toSimulateDefinition),
        detected_fields: input.detectedFields && !(0, _lodash.isEmpty)(input.detectedFields) ? (0, _utils2.getMappedSchemaFields)(input.detectedFields).map(field => ({
          name: field.name,
          ...(0, _utils3.convertToFieldDefinitionConfig)(field)
        })) : undefined
      }
    }
  }));
}
function createSimulationRunFailureNofitier({
  toasts
}) {
  return params => {
    const event = params.event;
    toasts.addError(new Error(event.error.body.message), {
      title: _i18n.i18n.translate('xpack.streams.enrichment.simulation.simulationRunError', {
        defaultMessage: 'An issue occurred running the simulation.'
      }),
      toastMessage: event.error.body.message
    });
  };
}