"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configDrivenProcessors = void 0;
var _kv = require("./configs/kv");
var _geoip = require("./configs/geoip");
var _rename = require("./configs/rename");
var _set = require("./configs/set");
var _url_decode = require("./configs/url_decode");
var _user_agent = require("./configs/user_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configDrivenProcessors = exports.configDrivenProcessors = {
  kv: _kv.kvProcessorConfig,
  geoip: _geoip.geoIpProcessorConfig,
  rename: _rename.renameProcessorConfig,
  set: _set.setProcessorConfig,
  urldecode: _url_decode.urlDecodeProcessorConfig,
  user_agent: _user_agent.userAgentProcessorConfig
};