"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectedFieldsEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _streamsSchema = require("@kbn/streams-schema");
var _asset_image = require("../../asset_image");
var _schema_editor = require("../schema_editor");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectedFieldsEditor = ({
  detectedFields
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    mapField,
    unmapField
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const definition = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.definition);
  const isWiredStream = _streamsSchema.Streams.WiredStream.GetResponse.is(definition);
  const hasFields = detectedFields.length > 0;
  if (!hasFields) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      titleSize: "xs",
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults"
      }),
      body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.detectedFields.noResults.content', {
        defaultMessage: 'No fields were detected during the simulation. You can add fields manually in the Schema Editor.'
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isWiredStream && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    color: "subdued",
    size: "xs",
    css: (0, _react2.css)`
            margin-bottom: ${euiTheme.size.base};
          `
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.detectedFieldsHeadline', {
    defaultMessage: 'You can review and adjust saved fields further in the Schema Editor.'
  })), /*#__PURE__*/_react.default.createElement(_schema_editor.SchemaEditor, {
    defaultColumns: isWiredStream ? ['name', 'type', 'format', 'status'] : ['name', 'type'],
    fields: detectedFields,
    stream: definition.stream,
    onFieldUnmap: unmapField,
    onFieldUpdate: mapField,
    withTableActions: isWiredStream,
    withToolbar: isWiredStream
  }));
};
exports.DetectedFieldsEditor = DetectedFieldsEditor;