"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionMessage = ConditionMessage;
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConditionMessage({
  condition
}) {
  if ((0, _streamsSchema.isAlwaysCondition)(condition) || (0, _streamsSchema.isNeverCondition)(condition)) {
    return '';
  }
  if ((0, _streamsSchema.isFilterCondition)(condition)) {
    if ((0, _streamsSchema.isBinaryFilterCondition)(condition)) {
      return _i18n.i18n.translate('xpack.streams.filterDisplay.binary', {
        defaultMessage: '{field} {operator} {value}',
        values: {
          field: condition.field,
          operator: condition.operator,
          value: condition.value
        }
      });
    } else {
      return _i18n.i18n.translate('xpack.streams.filterDisplay.unary', {
        defaultMessage: '{field} {operator}',
        values: {
          field: condition.field,
          operator: condition.operator
        }
      });
    }
  } else if ((0, _streamsSchema.isAndCondition)(condition)) {
    if (condition.and.length === 0) {
      return '';
    }
    if (condition.and.length === 1) {
      return /*#__PURE__*/_react.default.createElement(ConditionMessage, {
        condition: condition.and[0]
      });
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.andDisplay.andLabel",
      defaultMessage: "{left} AND {right}",
      values: {
        left: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: condition.and[0]
        }),
        right: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: {
            ...condition,
            and: condition.and.slice(1)
          }
        })
      }
    });
  } else if ((0, _streamsSchema.isOrCondition)(condition)) {
    if (condition.or.length === 0) {
      return '';
    }
    if (condition.or.length === 1) {
      return /*#__PURE__*/_react.default.createElement(ConditionMessage, {
        condition: condition.or[0]
      });
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.orDisplay.orLabel",
      defaultMessage: "{left} OR {right}",
      values: {
        left: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: condition.or[0]
        }),
        right: /*#__PURE__*/_react.default.createElement(ConditionMessage, {
          condition: {
            ...condition,
            or: condition.or.slice(1)
          }
        })
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.orDisplay.invalidConditionLabel",
    defaultMessage: "Invalid condition format"
  });
}