"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionEditor = ConditionEditor;
exports.RoutingConditionEditor = RoutingConditionEditor;
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _eui = require("@elastic/eui");
var _streamsSchema = require("@kbn/streams-schema");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _lodash = require("lodash");
var _condition = require("../../../util/condition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RoutingConditionEditor(props) {
  const isEnabled = !(0, _streamsSchema.isNeverCondition)(props.condition);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, _i18n.i18n.translate('xpack.streams.conditionEditor.title', {
      defaultMessage: 'Status'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.streams.conditionEditor.disableTooltip', {
        defaultMessage: 'When disabled, the routing rule stops sending documents to this stream. It does not remove existing data.'
      })
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.conditionEditor.switch', {
      defaultMessage: 'Enabled'
    }),
    compressed: true,
    checked: isEnabled,
    onChange: event => {
      props.onConditionChange(event.target.checked ? _condition.ALWAYS_CONDITION : _condition.NEVER_CONDITION);
    }
  })), isEnabled && /*#__PURE__*/_react.default.createElement(ConditionEditor, props));
}
const operatorMap = {
  eq: _i18n.i18n.translate('xpack.streams.filter.equals', {
    defaultMessage: 'equals'
  }),
  neq: _i18n.i18n.translate('xpack.streams.filter.notEquals', {
    defaultMessage: 'not equals'
  }),
  lt: _i18n.i18n.translate('xpack.streams.filter.lessThan', {
    defaultMessage: 'less than'
  }),
  lte: _i18n.i18n.translate('xpack.streams.filter.lessThanOrEquals', {
    defaultMessage: 'less than or equals'
  }),
  gt: _i18n.i18n.translate('xpack.streams.filter.greaterThan', {
    defaultMessage: 'greater than'
  }),
  gte: _i18n.i18n.translate('xpack.streams.filter.greaterThanOrEquals', {
    defaultMessage: 'greater than or equals'
  }),
  contains: _i18n.i18n.translate('xpack.streams.filter.contains', {
    defaultMessage: 'contains'
  }),
  startsWith: _i18n.i18n.translate('xpack.streams.filter.startsWith', {
    defaultMessage: 'starts with'
  }),
  endsWith: _i18n.i18n.translate('xpack.streams.filter.endsWith', {
    defaultMessage: 'ends with'
  }),
  exists: _i18n.i18n.translate('xpack.streams.filter.exists', {
    defaultMessage: 'exists'
  }),
  notExists: _i18n.i18n.translate('xpack.streams.filter.notExists', {
    defaultMessage: 'not exists'
  })
};
const operatorOptions = Object.entries(operatorMap).map(([value, text]) => ({
  value,
  text
}));
function ConditionEditor(props) {
  const isInvalidCondition = !(0, _streamsSchema.isCondition)(props.condition);
  const condition = (0, _condition.alwaysToEmptyEquals)(props.condition);
  const isFilterCondition = (0, _lodash.isPlainObject)(condition) && 'operator' in condition;
  const [usingSyntaxEditor, toggleSyntaxEditor] = (0, _useToggle.default)(!isFilterCondition);
  const handleConditionChange = updatedCondition => {
    props.onConditionChange((0, _condition.emptyEqualsToAlways)(updatedCondition));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.conditionEditor.title', {
      defaultMessage: 'Condition'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.streams.conditionEditor.switch', {
        defaultMessage: 'Syntax editor'
      }),
      compressed: true,
      checked: usingSyntaxEditor,
      onChange: toggleSyntaxEditor
    }),
    isInvalid: isInvalidCondition,
    error: isInvalidCondition ? _i18n.i18n.translate('xpack.streams.conditionEditor.error', {
      defaultMessage: 'The condition is invalid or in unrecognized format.'
    }) : undefined
  }, usingSyntaxEditor ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 200,
    languageId: "json",
    value: JSON.stringify(condition, null, 2),
    onChange: value => {
      try {
        handleConditionChange(JSON.parse(value));
      } catch (error) {
        // do nothing
      }
    }
  }) : isFilterCondition ? /*#__PURE__*/_react.default.createElement(FilterForm, {
    condition: condition,
    onConditionChange: handleConditionChange
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    paddingSize: "m",
    isCopyable: true
  }, JSON.stringify(condition, null, 2)));
}
function FilterForm(props) {
  const handleConditionChange = updatedCondition => {
    props.onConditionChange({
      ...props.condition,
      ...updatedCondition
    });
  };
  const handleOperatorChange = event => {
    const newCondition = {
      ...props.condition
    };
    const newOperator = event.target.value;
    if (newOperator === 'exists' || newOperator === 'notExists') {
      if ('value' in newCondition) delete newCondition.value;
    } else if (!('value' in newCondition)) {
      newCondition.value = '';
    }
    props.onConditionChange({
      ...newCondition,
      operator: newOperator
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "streamsAppFilterFormFieldText",
    "aria-label": _i18n.i18n.translate('xpack.streams.filter.field', {
      defaultMessage: 'Field'
    }),
    compressed: true,
    placeholder: _i18n.i18n.translate('xpack.streams.filter.fieldPlaceholder', {
      defaultMessage: 'Field'
    }),
    value: props.condition.field,
    onChange: e => {
      handleConditionChange({
        field: e.target.value
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.streams.filter.operator', {
      defaultMessage: 'Operator'
    }),
    "data-test-subj": "streamsAppFilterFormSelect",
    options: operatorOptions,
    value: props.condition.operator,
    compressed: true,
    onChange: handleOperatorChange
  }), 'value' in props.condition && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _i18n.i18n.translate('xpack.streams.filter.value', {
      defaultMessage: 'Value'
    }),
    placeholder: _i18n.i18n.translate('xpack.streams.filter.valuePlaceholder', {
      defaultMessage: 'Value'
    }),
    compressed: true,
    value: String(props.condition.value),
    "data-test-subj": "streamsAppFilterFormValueText",
    onChange: e => {
      handleConditionChange({
        value: e.target.value
      });
    }
  }));
}