"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueTextContent = exports.formatUpdateRequest = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValueTextContent = (field, value) => {
  if (field === 'description') {
    return {
      textarea: {
        format: 'html',
        content: value.toString()
      }
    };
  }
  if (field === 'incidentTypes') {
    if ((0, _lodash.isArray)(value)) {
      return {
        ids: value.map(item => Number(item))
      };
    }
    return {
      ids: [Number(value)]
    };
  }
  if (field === 'severityCode') {
    return {
      id: Number(value)
    };
  }
  return {
    text: value.toString()
  };
};
exports.getValueTextContent = getValueTextContent;
const formatUpdateRequest = ({
  oldIncident,
  newIncident
}) => {
  return {
    changes: Object.keys(newIncident).map(key => {
      let name = key;
      if (key === 'incidentTypes') {
        name = 'incident_type_ids';
      }
      if (key === 'severityCode') {
        name = 'severity_code';
      }
      return {
        field: {
          name
        },
        old_value: getValueTextContent(key, name === 'description' ? oldIncident.description.content : oldIncident[name]),
        new_value: getValueTextContent(key, newIncident[key])
      };
    })
  };
};
exports.formatUpdateRequest = formatUpdateRequest;