"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chunksIntoMessage = chunksIntoMessage;
exports.eventSourceStreamIntoObservable = eventSourceStreamIntoObservable;
var _rxjs = require("rxjs");
var _eventsourceParser = require("eventsource-parser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Extract to the common package with appex-ai
function eventSourceStreamIntoObservable(readable) {
  return new _rxjs.Observable(subscriber => {
    const parser = (0, _eventsourceParser.createParser)({
      onEvent: event => {
        subscriber.next(event.data);
      }
    });
    async function processStream() {
      for await (const chunk of readable) {
        parser.feed(chunk.toString());
      }
    }
    processStream().then(() => {
      subscriber.complete();
    }, error => {
      subscriber.error(error);
    });
  });
}
function chunksIntoMessage(obs$) {
  const shared$ = obs$.pipe((0, _rxjs.share)());
  return (0, _rxjs.lastValueFrom)((0, _rxjs.merge)(shared$, shared$.pipe((0, _rxjs.scan)((prev, chunk) => {
    if (chunk.choices.length > 0 && !chunk.usage) {
      var _chunk$choices$0$mess, _chunk$choices$0$mess2;
      prev.choices[0].message.content += (_chunk$choices$0$mess = chunk.choices[0].message.content) !== null && _chunk$choices$0$mess !== void 0 ? _chunk$choices$0$mess : '';
      if (chunk.choices[0].message.refusal) {
        prev.choices[0].message.refusal = chunk.choices[0].message.refusal;
      }
      (_chunk$choices$0$mess2 = chunk.choices[0].message.tool_calls) === null || _chunk$choices$0$mess2 === void 0 ? void 0 : _chunk$choices$0$mess2.forEach(toolCall => {
        if (toolCall.index !== undefined) {
          var _prev$choices$0$messa, _prev$choices$0$messa2, _toolCall$function, _toolCall$function3;
          const prevToolCallLength = (_prev$choices$0$messa = (_prev$choices$0$messa2 = prev.choices[0].message.tool_calls) === null || _prev$choices$0$messa2 === void 0 ? void 0 : _prev$choices$0$messa2.length) !== null && _prev$choices$0$messa !== void 0 ? _prev$choices$0$messa : 0;
          if (prevToolCallLength - 1 !== toolCall.index) {
            if (!prev.choices[0].message.tool_calls) {
              prev.choices[0].message.tool_calls = [];
            }
            prev.choices[0].message.tool_calls.push({
              function: {
                name: '',
                arguments: ''
              },
              id: ''
            });
          }
          const prevToolCall = prev.choices[0].message.tool_calls[toolCall.index];
          if ((_toolCall$function = toolCall.function) !== null && _toolCall$function !== void 0 && _toolCall$function.name) {
            var _toolCall$function2;
            prevToolCall.function.name += (_toolCall$function2 = toolCall.function) === null || _toolCall$function2 === void 0 ? void 0 : _toolCall$function2.name;
          }
          if ((_toolCall$function3 = toolCall.function) !== null && _toolCall$function3 !== void 0 && _toolCall$function3.arguments) {
            var _toolCall$function4;
            prevToolCall.function.arguments += (_toolCall$function4 = toolCall.function) === null || _toolCall$function4 === void 0 ? void 0 : _toolCall$function4.arguments;
          }
          if (toolCall.id) {
            prevToolCall.id += toolCall.id;
          }
          if (toolCall.type) {
            prevToolCall.type = toolCall.type;
          }
        }
      });
    } else if (chunk.usage) {
      prev.usage = chunk.usage;
    }
    return {
      ...prev,
      id: chunk.id,
      model: chunk.model
    };
  }, {
    choices: [{
      message: {
        content: '',
        refusal: null,
        role: 'assistant'
      }
    }],
    object: 'chat.completion'
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
  }), (0, _rxjs.last)(), (0, _rxjs.map)(concatenatedChunk => {
    var _concatenatedChunk$ch;
    // TODO: const validatedToolCalls = validateToolCalls(concatenatedChunk.choices[0].message.tool_calls);
    if (concatenatedChunk.choices[0].message.content === '') {
      concatenatedChunk.choices[0].message.content = null;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (_concatenatedChunk$ch = concatenatedChunk.choices[0].message.tool_calls) === null || _concatenatedChunk$ch === void 0 ? void 0 : _concatenatedChunk$ch.forEach(toolCall => {
      var _toolCall$function5, _toolCall$function5$a;
      if (((_toolCall$function5 = toolCall.function) === null || _toolCall$function5 === void 0 ? void 0 : (_toolCall$function5$a = _toolCall$function5.arguments) === null || _toolCall$function5$a === void 0 ? void 0 : _toolCall$function5$a.trim()) === '') {
        toolCall.function.arguments = '{}';
      }
    });
    return concatenatedChunk;
  }))));
}