"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_LABEL = exports.START_INVESTIGATION_LABEL = exports.SEVERITY_LABEL = exports.SELECT_MESSAGE = exports.PLAYBOOK_PLACEHOLDER = exports.PLAYBOOK_NOT_FOUND_WARNING = exports.PLAYBOOK_LABEL = exports.PLAYBOOK_HELP = exports.PLAYBOOK_ARIA_LABEL = exports.PLAYBOOKS_ERROR = exports.NAME_REQUIRED = exports.NAME_LABEL = exports.IS_RULE_SEVERITY_LABEL = exports.BODY_REQUIRED = exports.BODY_LABEL = exports.BODY_DESCRIPTION = exports.API_KEY_LABEL = exports.API_KEY_ID_LABEL = exports.API_KEY_ID_HELP_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.urlFieldLabel', {
  defaultMessage: 'URL'
});
const SELECT_MESSAGE = exports.SELECT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.selectMessageText', {
  defaultMessage: 'Create an incident in XSOAR'
});
const API_KEY_LABEL = exports.API_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.apiKeyFieldLabel', {
  defaultMessage: 'API key'
});
const API_KEY_ID_LABEL = exports.API_KEY_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.apiKeyIDFieldLabel', {
  defaultMessage: 'API key ID'
});
const API_KEY_ID_HELP_TEXT = exports.API_KEY_ID_HELP_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.apiKeyIDFieldHelpText', {
  defaultMessage: 'Enter the API key ID (the unique serial number for your API key) to authenticate with your XSOAR cloud instance.'
});
const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.nameFieldLabel', {
  defaultMessage: 'Name'
});
const NAME_REQUIRED = exports.NAME_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.error.requiredNameText', {
  defaultMessage: 'Incident name is required.'
});
const BODY_REQUIRED = exports.BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.error.requiredBodyText', {
  defaultMessage: 'Body is required.'
});
const START_INVESTIGATION_LABEL = exports.START_INVESTIGATION_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.startInvestigationToggleLabel', {
  defaultMessage: 'Start investigation'
});
const SEVERITY_LABEL = exports.SEVERITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.severitySelectInputLabel', {
  defaultMessage: 'Severity'
});
const IS_RULE_SEVERITY_LABEL = exports.IS_RULE_SEVERITY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.isRuleSeverityToggleLabel', {
  defaultMessage: 'Use severity assigned to the rule'
});
const PLAYBOOKS_ERROR = exports.PLAYBOOKS_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.componentError.playbooksRequestFailed', {
  defaultMessage: 'Unable to retrieve playbooks from XSOAR.'
});
const PLAYBOOK_NOT_FOUND_WARNING = exports.PLAYBOOK_NOT_FOUND_WARNING = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.componentWarning.playbookNotFound', {
  defaultMessage: 'Could not find the selected playbook. Choose a different one.'
});
const BODY_LABEL = exports.BODY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.bodyFieldLabel', {
  defaultMessage: 'Body'
});
const BODY_DESCRIPTION = exports.BODY_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.bodyCodeEditorAriaLabel', {
  defaultMessage: 'Code editor'
});
const PLAYBOOK_LABEL = exports.PLAYBOOK_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.playbookFieldLabel', {
  defaultMessage: 'XSOAR playbooks'
});
const PLAYBOOK_HELP = exports.PLAYBOOK_HELP = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.playbookHelp', {
  defaultMessage: 'The XSOAR playbook to associate with incident'
});
const PLAYBOOK_PLACEHOLDER = exports.PLAYBOOK_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.playbookPlaceholder', {
  defaultMessage: 'Select a playbook'
});
const PLAYBOOK_ARIA_LABEL = exports.PLAYBOOK_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.params.playbookFieldAriaLabel', {
  defaultMessage: 'Select an XSOAR playbook.'
});