"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_NOT_TORQ_WEBHOOK = exports.URL_LABEL = exports.URL_INVALID = exports.URL_HELP_TEXT = exports.TORQ_TOKEN_REQUIRED = exports.TORQ_TOKEN_LABEL = exports.TORQ_TOKEN_HELP_TEXT = exports.TORQ_SELECT_MESSAGE = exports.TORQ_ACTION_TYPE_TITLE = exports.INVALID_JSON = exports.HOW_TO_TEXT = exports.BODY_REQUIRED = exports.BODY_FIELD_LABEL = exports.BODY_FIELD_ARIA_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.torqAction.urlTextFieldLabel', {
  defaultMessage: 'Torq endpoint URL'
});
const URL_INVALID = exports.URL_INVALID = _i18n.i18n.translate('xpack.stackConnectors.torqAction.error.invalidUrlTextField', {
  defaultMessage: 'URL is invalid.'
});
const BODY_FIELD_LABEL = exports.BODY_FIELD_LABEL = _i18n.i18n.translate('xpack.stackConnectors.torqAction.bodyFieldLabel', {
  defaultMessage: 'Body'
});
const BODY_FIELD_ARIA_LABEL = exports.BODY_FIELD_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.torqAction.bodyCodeEditorAriaLabel', {
  defaultMessage: 'Code editor'
});
const URL_NOT_TORQ_WEBHOOK = exports.URL_NOT_TORQ_WEBHOOK = _i18n.i18n.translate('xpack.stackConnectors.torqAction.error.urlIsNotTorqWebhook', {
  defaultMessage: 'URL is not a Torq integration endpoint.'
});
const TORQ_TOKEN_LABEL = exports.TORQ_TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.torqAction.token', {
  defaultMessage: 'Torq integration token'
});
const TORQ_TOKEN_REQUIRED = exports.TORQ_TOKEN_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.error.requiredWebhookTorqTokenText', {
  defaultMessage: 'Torq integration token is required.'
});
const BODY_REQUIRED = exports.BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.error.requiredWebhookBodyText', {
  defaultMessage: 'Body is required.'
});
const INVALID_JSON = exports.INVALID_JSON = _i18n.i18n.translate('xpack.stackConnectors.error.requireValidJSONBody', {
  defaultMessage: 'Body must be a valid JSON.'
});
const TORQ_SELECT_MESSAGE = exports.TORQ_SELECT_MESSAGE = _i18n.i18n.translate('xpack.stackConnectors.torqAction.selectMessageText', {
  defaultMessage: 'Trigger a Torq workflow.'
});
const TORQ_ACTION_TYPE_TITLE = exports.TORQ_ACTION_TYPE_TITLE = _i18n.i18n.translate('xpack.stackConnectors.torqAction.actionTypeTitle', {
  defaultMessage: 'Alert data'
});
const TORQ_TOKEN_HELP_TEXT = exports.TORQ_TOKEN_HELP_TEXT = _i18n.i18n.translate('xpack.stackConnectors.torqAction.tokenHelpText', {
  defaultMessage: 'Enter the webhook authentication header secret generated when you created the Elastic Security integration.'
});
const URL_HELP_TEXT = exports.URL_HELP_TEXT = _i18n.i18n.translate('xpack.stackConnectors.torqAction.urlHelpText', {
  defaultMessage: 'Enter the endpoint URL generated when you created the Elastic Security integration on Torq.'
});
const HOW_TO_TEXT = exports.HOW_TO_TEXT = _i18n.i18n.translate('xpack.stackConnectors.torqActionConnectorFields.calloutTitle', {
  defaultMessage: 'Create an Elastic Security integration on Torq, and then come back and paste the endpoint URL and token generated for your integration.'
});