"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionType = getActionType;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const torqDefaultBody = `{
  "alert": {{alert}},
  "context": {{context}},
  "rule": {{rule}},
  "state": {{state}},
  "date": "{{date}}",
  "kibana_base_url": "{{kibanaBaseUrl}}"
}`;
function replaceReferencesWithNumbers(body) {
  return body.replace(/\{\{[.\w]+\}\}/gm, '42');
}
function getActionType() {
  const validateParams = async actionParams => {
    var _actionParams$body;
    const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
    const errors = {
      body: []
    };
    const validationResult = {
      errors
    };
    validationResult.errors = errors;
    if (!((_actionParams$body = actionParams.body) !== null && _actionParams$body !== void 0 && _actionParams$body.length)) {
      errors.body.push(translations.BODY_REQUIRED);
    } else {
      try {
        JSON.parse(replaceReferencesWithNumbers(actionParams.body || ''));
      } catch (e) {
        errors.body.push(translations.INVALID_JSON);
      }
    }
    return validationResult;
  };
  return {
    id: '.torq',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: i18n.TORQ_SELECT_MESSAGE,
    actionTypeTitle: i18n.TORQ_ACTION_TYPE_TITLE,
    validateParams,
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./torq_connectors')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./torq_params')))),
    defaultActionParams: {
      body: torqDefaultBody
    }
  };
}