"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ServerLogParamsFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ServerLogParamsFields = ({
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  defaultMessage,
  useDefaultMessage
}) => {
  const {
    message,
    level
  } = actionParams;
  const levelOptions = [{
    value: 'trace',
    text: 'Trace'
  }, {
    value: 'debug',
    text: 'Debug'
  }, {
    value: 'info',
    text: 'Info'
  }, {
    value: 'warn',
    text: 'Warning'
  }, {
    value: 'error',
    text: 'Error'
  }, {
    value: 'fatal',
    text: 'Fatal'
  }];
  (0, _react.useEffect)(() => {
    if (!actionParams.level) {
      editAction('level', 'info', index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams.level]);
  const [[isUsingDefault, defaultMessageUsed], setDefaultMessageUsage] = (0, _react.useState)([false, defaultMessage]);
  (0, _react.useEffect)(() => {
    if (useDefaultMessage || !(actionParams !== null && actionParams !== void 0 && actionParams.message) || isUsingDefault && (actionParams === null || actionParams === void 0 ? void 0 : actionParams.message) === defaultMessageUsed && defaultMessageUsed !== defaultMessage) {
      setDefaultMessageUsage([true, defaultMessage]);
      editAction('message', defaultMessage, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [defaultMessage]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "loggingLevel",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.serverLog.logLevelFieldLabel', {
      defaultMessage: 'Level'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    id: "loggLevelSelect",
    "data-test-subj": "loggingLevelSelect",
    options: levelOptions,
    value: level,
    defaultValue: 'info',
    onChange: e => {
      editAction('level', e.target.value, index);
    }
  })), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'message',
    inputTargetValue: message,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.serverLog.logMessageFieldLabel', {
      defaultMessage: 'Message'
    }),
    errors: errors.message
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ServerLogParamsFields = ServerLogParamsFields;