"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIncidentTypes = getIncidentTypes;
exports.getSeverity = getSeverity;
var _common = require("@kbn/actions-plugin/common");
var _rewrite_response_body = require("../lib/rewrite_response_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getIncidentTypes({
  http,
  signal,
  connectorId
}) {
  const res = await http.post(`${_common.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(connectorId)}/_execute`, {
    body: JSON.stringify({
      params: {
        subAction: 'incidentTypes',
        subActionParams: {}
      }
    }),
    signal
  });
  return (0, _rewrite_response_body.rewriteResponseToCamelCase)(res);
}
async function getSeverity({
  http,
  signal,
  connectorId
}) {
  const res = await http.post(`${_common.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(connectorId)}/_execute`, {
    body: JSON.stringify({
      params: {
        subAction: 'severity',
        subActionParams: {}
      }
    }),
    signal
  });
  return (0, _rewrite_response_body.rewriteResponseToCamelCase)(res);
}