"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decodeSchema = exports.DecodeError = void 0;
exports.isDecodeError = isDecodeError;
var _Either = require("fp-ts/lib/Either");
var _pipeable = require("fp-ts/lib/pipeable");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _function = require("fp-ts/lib/function");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatErrors = errors => {
  const err = errors.map(error => {
    if (error.message != null) {
      return error.message;
    } else {
      const keyContext = error.context.filter(entry => entry.key != null && !Number.isInteger(+entry.key) && entry.key.trim() !== '').map(entry => entry.key).join('.');
      const nameContext = error.context.find(entry => entry.type != null && entry.type.name != null && entry.type.name.length > 0);
      const suppliedValue = keyContext !== '' ? keyContext : nameContext != null ? nameContext.type.name : '';
      const value = (0, _lodash.isObject)(error.value) ? JSON.stringify(error.value) : error.value;
      return `Invalid value "${value}" supplied to "${suppliedValue}"`;
    }
  });
  return [...new Set(err)];
};
const decodeSchema = (schema, data) => {
  const onLeft = errors => {
    throw new DecodeError(formatErrors(errors));
  };
  const onRight = schemaType => (0, _function.identity)(schemaType);
  return (0, _pipeable.pipe)(schema.decode(data), decoded => (0, _securitysolutionIoTsUtils.exactCheck)(data, decoded), (0, _Either.fold)(onLeft, onRight));
};
exports.decodeSchema = decodeSchema;
class DecodeError extends Error {
  constructor(decodeErrors) {
    super(decodeErrors.join());
    this.decodeErrors = decodeErrors;
    this.name = this.constructor.name;
  }
}
exports.DecodeError = DecodeError;
function isDecodeError(error) {
  return error instanceof DecodeError;
}