"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SNStoreLink = exports.SNStoreButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStoreURL = appId => `https://store.servicenow.com/sn_appstore_store.do#!/store/application/${appId}`;
const SNStoreButtonComponent = ({
  color,
  appId = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: getStoreURL(appId),
    color: color,
    iconSide: "right",
    iconType: "popout",
    target: "_blank"
  }, i18n.VISIT_SN_STORE);
};
const SNStoreButton = exports.SNStoreButton = /*#__PURE__*/(0, _react.memo)(SNStoreButtonComponent);
const SNStoreLinkComponent = ({
  appId = ''
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: getStoreURL(appId),
  target: "_blank"
}, i18n.VISIT_SN_STORE);
const SNStoreLink = exports.SNStoreLink = /*#__PURE__*/(0, _react.memo)(SNStoreLinkComponent);