"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USAGE_DASHBOARD_LINK = exports.URL_LABEL = exports.SECRET = exports.MODEL = exports.INVALID_ACTION = exports.DOCUMENTATION = exports.DEFAULT_MODEL_LABEL = exports.BODY_REQUIRED = exports.BODY_INVALID = exports.BODY_DESCRIPTION = exports.BODY = exports.BEDROCK = exports.API_URL_LABEL = exports.ACTION_REQUIRED = exports.ACCESS_KEY_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = exports.API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
const ACCESS_KEY_LABEL = exports.ACCESS_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.accessKeySecret', {
  defaultMessage: 'Access Key'
});
const DEFAULT_MODEL_LABEL = exports.DEFAULT_MODEL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.defaultModelTextFieldLabel', {
  defaultMessage: 'Default model'
});
const SECRET = exports.SECRET = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.secret', {
  defaultMessage: 'Secret'
});
const BEDROCK = exports.BEDROCK = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.title', {
  defaultMessage: 'Amazon Bedrock'
});
const DOCUMENTATION = exports.DOCUMENTATION = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.documentation', {
  defaultMessage: 'documentation'
});
const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.urlTextFieldLabel', {
  defaultMessage: 'URL'
});
const BODY_REQUIRED = exports.BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.error.requiredBedrockBodyText', {
  defaultMessage: 'Body is required.'
});
const BODY_INVALID = exports.BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.bedrock.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
const ACTION_REQUIRED = exports.ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.bedrock.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
const INVALID_ACTION = exports.INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.bedrock.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
const BODY = exports.BODY = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.bodyFieldLabel', {
  defaultMessage: 'Body'
});
const BODY_DESCRIPTION = exports.BODY_DESCRIPTION = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.bodyCodeEditorAriaLabel', {
  defaultMessage: 'Code editor'
});
const MODEL = exports.MODEL = _i18n.i18n.translate('xpack.stackConnectors.components.bedrock.model', {
  defaultMessage: 'Model'
});
const USAGE_DASHBOARD_LINK = (apiProvider, connectorName) => _i18n.i18n.translate('xpack.stackConnectors.components.genAi.dashboardLink', {
  values: {
    apiProvider,
    connectorName
  },
  defaultMessage: 'View {apiProvider} Usage Dashboard for "{ connectorName }" Connector'
});
exports.USAGE_DASHBOARD_LINK = USAGE_DASHBOARD_LINK;