"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsExperimentalFeatureEnabled = void 0;
var _experimental_features = require("../../common/experimental_features");
var _experimental_features_service = require("./experimental_features_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allowedExperimentalValueKeys = (0, _experimental_features.getExperimentalAllowedValues)();
const getIsExperimentalFeatureEnabled = feature => {
  if (!(0, _experimental_features.isValidExperimentalValue)(feature)) {
    throw new Error(`Invalid enable value ${feature}. Allowed values are: ${allowedExperimentalValueKeys.join(', ')}`);
  }
  return _experimental_features_service.ExperimentalFeaturesService.get()[feature];
};
exports.getIsExperimentalFeatureEnabled = getIsExperimentalFeatureEnabled;