"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TheHiveUpdateIncidentResponseSchema = exports.TheHiveSecretsSchema = exports.TheHiveIncidentResponseSchema = exports.TheHiveFailureResponseSchema = exports.TheHiveCreateAlertResponseSchema = exports.TheHiveConfigSchema = exports.TheHiveAddCommentResponseSchema = exports.PushToServiceIncidentSchema = exports.ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionCreateAlertParamsSchema = exports.ExecutorParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TheHiveConfigSchema = exports.TheHiveConfigSchema = _configSchema.schema.object({
  url: _configSchema.schema.string(),
  organisation: _configSchema.schema.nullable(_configSchema.schema.string())
});
const TheHiveSecretsSchema = exports.TheHiveSecretsSchema = _configSchema.schema.object({
  apiKey: _configSchema.schema.string()
});
const ExecutorSubActionPushParamsSchema = exports.ExecutorSubActionPushParamsSchema = _configSchema.schema.object({
  incident: _configSchema.schema.object({
    title: _configSchema.schema.string(),
    description: _configSchema.schema.string(),
    externalId: _configSchema.schema.nullable(_configSchema.schema.string()),
    severity: _configSchema.schema.nullable(_configSchema.schema.number({
      defaultValue: _constants.TheHiveSeverity.MEDIUM
    })),
    tlp: _configSchema.schema.nullable(_configSchema.schema.number({
      defaultValue: _constants.TheHiveTLP.AMBER
    })),
    tags: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }),
  comments: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({
    comment: _configSchema.schema.string(),
    commentId: _configSchema.schema.string()
  })))
});
const PushToServiceIncidentSchema = exports.PushToServiceIncidentSchema = {
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string(),
  severity: _configSchema.schema.nullable(_configSchema.schema.number()),
  tlp: _configSchema.schema.nullable(_configSchema.schema.number()),
  tags: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))
};
const ExecutorSubActionGetIncidentParamsSchema = exports.ExecutorSubActionGetIncidentParamsSchema = _configSchema.schema.object({
  externalId: _configSchema.schema.string()
});
const ExecutorSubActionCreateAlertParamsSchema = exports.ExecutorSubActionCreateAlertParamsSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  source: _configSchema.schema.string(),
  sourceRef: _configSchema.schema.string(),
  severity: _configSchema.schema.nullable(_configSchema.schema.number({
    defaultValue: _constants.TheHiveSeverity.MEDIUM
  })),
  isRuleSeverity: _configSchema.schema.nullable(_configSchema.schema.boolean({
    defaultValue: false
  })),
  tlp: _configSchema.schema.nullable(_configSchema.schema.number({
    defaultValue: _constants.TheHiveTLP.AMBER
  })),
  tags: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  body: _configSchema.schema.nullable(_configSchema.schema.string())
});
const ExecutorParamsSchema = exports.ExecutorParamsSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.PUSH_TO_SERVICE),
  subActionParams: ExecutorSubActionPushParamsSchema
}), _configSchema.schema.object({
  subAction: _configSchema.schema.literal(_constants.SUB_ACTION.CREATE_ALERT),
  subActionParams: ExecutorSubActionCreateAlertParamsSchema
})]);
const TheHiveIncidentResponseSchema = exports.TheHiveIncidentResponseSchema = _configSchema.schema.object({
  _id: _configSchema.schema.string(),
  _type: _configSchema.schema.string(),
  _createdBy: _configSchema.schema.string(),
  _updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  _createdAt: _configSchema.schema.number(),
  _updatedAt: _configSchema.schema.nullable(_configSchema.schema.number()),
  number: _configSchema.schema.number(),
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string(),
  severity: _configSchema.schema.number(),
  severityLabel: _configSchema.schema.string(),
  startDate: _configSchema.schema.number(),
  endDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  tags: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  flag: _configSchema.schema.boolean(),
  tlp: _configSchema.schema.number(),
  tlpLabel: _configSchema.schema.string(),
  pap: _configSchema.schema.number(),
  papLabel: _configSchema.schema.string(),
  status: _configSchema.schema.string(),
  stage: _configSchema.schema.string(),
  summary: _configSchema.schema.nullable(_configSchema.schema.string()),
  impactStatus: _configSchema.schema.nullable(_configSchema.schema.string()),
  assignee: _configSchema.schema.nullable(_configSchema.schema.string()),
  customFields: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))),
  userPermissions: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  extraData: _configSchema.schema.object({}, {
    unknowns: 'allow'
  }),
  newDate: _configSchema.schema.number(),
  inProgressDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  closedDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  alertDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  alertNewDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  alertInProgressDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  alertImportedDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  timeToDetect: _configSchema.schema.number(),
  timeToTriage: _configSchema.schema.nullable(_configSchema.schema.number()),
  timeToQualify: _configSchema.schema.nullable(_configSchema.schema.number()),
  timeToAcknowledge: _configSchema.schema.nullable(_configSchema.schema.number()),
  timeToResolve: _configSchema.schema.nullable(_configSchema.schema.number()),
  handlingDuration: _configSchema.schema.nullable(_configSchema.schema.number())
}, {
  unknowns: 'ignore'
});
const TheHiveUpdateIncidentResponseSchema = exports.TheHiveUpdateIncidentResponseSchema = _configSchema.schema.any();
const TheHiveAddCommentResponseSchema = exports.TheHiveAddCommentResponseSchema = _configSchema.schema.object({
  _id: _configSchema.schema.string(),
  _type: _configSchema.schema.string(),
  createdBy: _configSchema.schema.string(),
  createdAt: _configSchema.schema.number(),
  updatedAt: _configSchema.schema.nullable(_configSchema.schema.number()),
  updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  message: _configSchema.schema.string(),
  isEdited: _configSchema.schema.boolean(),
  extraData: _configSchema.schema.object({}, {
    unknowns: 'allow'
  })
}, {
  unknowns: 'ignore'
});
const TheHiveCreateAlertResponseSchema = exports.TheHiveCreateAlertResponseSchema = _configSchema.schema.object({
  _id: _configSchema.schema.string(),
  _type: _configSchema.schema.string(),
  _createdBy: _configSchema.schema.string(),
  _updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  _createdAt: _configSchema.schema.number(),
  _updatedAt: _configSchema.schema.nullable(_configSchema.schema.number()),
  type: _configSchema.schema.string(),
  source: _configSchema.schema.string(),
  sourceRef: _configSchema.schema.string(),
  externalLink: _configSchema.schema.nullable(_configSchema.schema.string()),
  title: _configSchema.schema.string(),
  description: _configSchema.schema.string(),
  severity: _configSchema.schema.number(),
  severityLabel: _configSchema.schema.string(),
  date: _configSchema.schema.number(),
  tags: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  tlp: _configSchema.schema.number(),
  tlpLabel: _configSchema.schema.string(),
  pap: _configSchema.schema.number(),
  papLabel: _configSchema.schema.string(),
  follow: _configSchema.schema.nullable(_configSchema.schema.boolean()),
  customFields: _configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))),
  caseTemplate: _configSchema.schema.nullable(_configSchema.schema.string()),
  observableCount: _configSchema.schema.number(),
  caseId: _configSchema.schema.nullable(_configSchema.schema.string()),
  status: _configSchema.schema.string(),
  stage: _configSchema.schema.string(),
  assignee: _configSchema.schema.nullable(_configSchema.schema.string()),
  summary: _configSchema.schema.nullable(_configSchema.schema.string()),
  extraData: _configSchema.schema.object({}, {
    unknowns: 'allow'
  }),
  newDate: _configSchema.schema.number(),
  inProgressDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  closedDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  importedDate: _configSchema.schema.nullable(_configSchema.schema.number()),
  timeToDetect: _configSchema.schema.number(),
  timeToTriage: _configSchema.schema.nullable(_configSchema.schema.number()),
  timeToQualify: _configSchema.schema.nullable(_configSchema.schema.number()),
  timeToAcknowledge: _configSchema.schema.nullable(_configSchema.schema.number())
}, {
  unknowns: 'ignore'
});
const TheHiveFailureResponseSchema = exports.TheHiveFailureResponseSchema = _configSchema.schema.object({
  type: _configSchema.schema.number(),
  message: _configSchema.schema.string()
}, {
  unknowns: 'ignore'
});