"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  registerBuiltInRuleTypes: true
};
exports.registerBuiltInRuleTypes = registerBuiltInRuleTypes;
var _index_threshold = require("./index_threshold");
var _geo_containment = require("./geo_containment");
var _es_query = require("./es_query");
var _constants = require("./constants");
Object.keys(_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _constants[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerBuiltInRuleTypes(params, isServerless) {
  (0, _index_threshold.register)(params);
  if (!isServerless) {
    (0, _geo_containment.register)(params);
  }
  (0, _es_query.register)(params, isServerless);
}