"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForShardFailures = checkForShardFailures;
exports.getParsedQuery = getParsedQuery;
exports.isEsQueryRule = isEsQueryRule;
exports.isEsqlQueryRule = isEsqlQueryRule;
exports.isSearchSourceRule = isSearchSourceRule;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isEsQueryRule(searchType) {
  return searchType === 'esQuery';
}
function isSearchSourceRule(searchType) {
  return searchType === 'searchSource';
}
function isEsqlQueryRule(searchType) {
  return searchType === 'esqlQuery';
}
function getParsedQuery(queryParams) {
  const {
    esQuery
  } = queryParams;
  let parsedQuery;
  try {
    parsedQuery = JSON.parse(esQuery);
  } catch (err) {
    throw new Error(getInvalidQueryError(esQuery));
  }
  if (parsedQuery && !parsedQuery.query) {
    throw new Error(getInvalidQueryError(esQuery));
  }
  return parsedQuery;
}
function getInvalidQueryError(query) {
  return _i18n.i18n.translate('xpack.stackAlerts.esQuery.invalidQueryErrorMessage', {
    defaultMessage: 'invalid query specified: "{query}" - query must be JSON',
    values: {
      query
    }
  });
}
function checkForShardFailures(searchResult) {
  var _searchResult$_shards, _searchResult$_shards2, _searchResult$_cluste, _searchResult$_cluste2;
  const anyShardsFailed = (_searchResult$_shards = searchResult === null || searchResult === void 0 ? void 0 : (_searchResult$_shards2 = searchResult._shards) === null || _searchResult$_shards2 === void 0 ? void 0 : _searchResult$_shards2.failed) !== null && _searchResult$_shards !== void 0 ? _searchResult$_shards : 0;
  if (anyShardsFailed > 0) {
    var _searchResult$_shards3, _searchResult$_shards4, _searchResult$_shards5, _searchResult$_shards6;
    const errorMessage = (searchResult === null || searchResult === void 0 ? void 0 : (_searchResult$_shards3 = searchResult._shards) === null || _searchResult$_shards3 === void 0 ? void 0 : (_searchResult$_shards4 = _searchResult$_shards3.failures) === null || _searchResult$_shards4 === void 0 ? void 0 : (_searchResult$_shards5 = _searchResult$_shards4[0]) === null || _searchResult$_shards5 === void 0 ? void 0 : (_searchResult$_shards6 = _searchResult$_shards5.reason) === null || _searchResult$_shards6 === void 0 ? void 0 : _searchResult$_shards6.reason) || 'Search returned partial results due to shard failures.';
    return errorMessage;
  }
  const anyClustersSkipped = (_searchResult$_cluste = searchResult === null || searchResult === void 0 ? void 0 : (_searchResult$_cluste2 = searchResult._clusters) === null || _searchResult$_cluste2 === void 0 ? void 0 : _searchResult$_cluste2.skipped) !== null && _searchResult$_cluste !== void 0 ? _searchResult$_cluste : 0;
  if (anyClustersSkipped) {
    var _searchResult$_cluste3, _searchResult$_cluste4;
    const details = (_searchResult$_cluste3 = searchResult === null || searchResult === void 0 ? void 0 : (_searchResult$_cluste4 = searchResult._clusters) === null || _searchResult$_cluste4 === void 0 ? void 0 : _searchResult$_cluste4.details) !== null && _searchResult$_cluste3 !== void 0 ? _searchResult$_cluste3 : {};
    for (const detail of Object.values(details)) {
      var _detail$failures, _detail$failures$, _detail$failures$$rea, _detail$failures$$rea2;
      const errorMessage = (detail === null || detail === void 0 ? void 0 : (_detail$failures = detail.failures) === null || _detail$failures === void 0 ? void 0 : (_detail$failures$ = _detail$failures[0]) === null || _detail$failures$ === void 0 ? void 0 : (_detail$failures$$rea = _detail$failures$.reason) === null || _detail$failures$$rea === void 0 ? void 0 : (_detail$failures$$rea2 = _detail$failures$$rea.caused_by) === null || _detail$failures$$rea2 === void 0 ? void 0 : _detail$failures$$rea2.reason) || 'Search returned partial results due to skipped cluster errors.';
      return errorMessage;
    }
  }
}