"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTriggerUiActionServices = exports.isSearchSourceRule = exports.isEsqlQueryRule = exports.convertRawRuntimeFieldtoFieldOption = exports.convertFieldSpecToFieldOption = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("@kbn/triggers-actions-ui-plugin/public/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isSearchSourceRule = ruleParams => {
  return ruleParams.searchType === 'searchSource';
};
exports.isSearchSourceRule = isSearchSourceRule;
const isEsqlQueryRule = ruleParams => {
  return ruleParams.searchType === 'esqlQuery';
};
exports.isEsqlQueryRule = isEsqlQueryRule;
const convertFieldSpecToFieldOption = fieldSpec => {
  return (fieldSpec !== null && fieldSpec !== void 0 ? fieldSpec : []).filter(spec => spec.isMapped || spec.runtimeField).map(spec => {
    const converted = {
      name: spec.name,
      searchable: spec.searchable,
      aggregatable: spec.aggregatable,
      type: spec.type,
      normalizedType: spec.type
    };
    if (spec.type === 'string') {
      const esType = spec.esTypes && spec.esTypes.length > 0 ? spec.esTypes[0] : spec.type;
      converted.type = esType;
      converted.normalizedType = esType;
    } else if (spec.type === 'number') {
      const esType = spec.esTypes && spec.esTypes.length > 0 ? spec.esTypes[0] : spec.type;
      converted.type = esType;
    }
    return converted;
  });
};
exports.convertFieldSpecToFieldOption = convertFieldSpecToFieldOption;
const convertRawRuntimeFieldtoFieldOption = rawFields => {
  const result = [];

  // verifying that the raw fields are an object
  let keys;
  try {
    keys = Object.keys(rawFields);
  } catch (e) {
    return result;
  }
  for (const name of keys) {
    const rawField = rawFields[name];
    const type = rawField.type;
    const normalizedType = _common.NORMALIZED_FIELD_TYPES[type] || type;
    const isAggregatableAndSearchable = type !== 'lookup';
    const aggregatable = isAggregatableAndSearchable;
    const searchable = isAggregatableAndSearchable;
    if (type) result.push({
      name,
      type,
      normalizedType,
      aggregatable,
      searchable
    });
  }
  return result;
};
exports.convertRawRuntimeFieldtoFieldOption = convertRawRuntimeFieldtoFieldOption;
const useTriggerUiActionServices = () => (0, _public.useKibana)().services;
exports.useTriggerUiActionServices = useTriggerUiActionServices;