"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyUrlConflictInternal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegacyUrlConflictInternal = props => {
  const {
    getStartServices,
    objectNoun = _constants.DEFAULT_OBJECT_NOUN,
    currentObjectId,
    otherObjectId,
    otherObjectPath
  } = props;
  const [isDismissed, setIsDismissed] = (0, _react.useState)(false);
  const {
    value: asyncParams
  } = (0, _useAsync.default)(async () => {
    const [{
      application: applicationStart,
      docLinks
    }] = await getStartServices();
    const appId = await applicationStart.currentAppId$.pipe((0, _rxjs.first)()).toPromise(); // retrieve the most recent value from the BehaviorSubject
    const docLink = docLinks.links.spaces.kibanaLegacyUrlAliases;
    return {
      applicationStart,
      appId,
      docLink
    };
  }, [getStartServices]);
  const {
    docLink,
    applicationStart,
    appId
  } = asyncParams !== null && asyncParams !== void 0 ? asyncParams : {};
  if (!applicationStart || !appId || !docLink || isDismissed) {
    return null;
  }
  function clickLinkButton() {
    applicationStart.navigateToApp(appId, {
      path: otherObjectPath
    });
  }
  function clickDismissButton() {
    setIsDismissed(true);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "question",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.legacyUrlConflict.calloutTitle",
      defaultMessage: "2 saved objects use this URL"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.legacyUrlConflict.calloutBodyText",
    defaultMessage: "Check that this is the {objectNoun} that you are looking for. Otherwise, go to the other one. {documentationLink}",
    values: {
      objectNoun,
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLink,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.spaces.legacyUrlConflict.documentationLinkText', {
        defaultMessage: 'Learn more'
      }))
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    delay: "long",
    content: _i18n.i18n.translate('xpack.spaces.legacyURLConflict.toolTipText', {
      defaultMessage: 'This {objectNoun} has [id={currentObjectId}]. The other {objectNoun} has [id={otherObjectId}].',
      values: {
        objectNoun,
        currentObjectId,
        otherObjectId
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    size: "s",
    onClick: clickLinkButton,
    "data-test-subj": "legacy-url-conflict-go-to-other-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.legacyUrlConflict.linkButton",
    defaultMessage: "Go to other {objectNoun}",
    values: {
      objectNoun
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "warning",
    size: "s",
    onClick: clickDismissButton,
    "data-test-subj": "legacy-url-conflict-dismiss-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.legacyUrlConflict.dismissButton",
    defaultMessage: "Dismiss"
  })))));
};
exports.LegacyUrlConflictInternal = LegacyUrlConflictInternal;