"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryAdd = void 0;
var _queryString = require("query-string");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _components = require("../../components");
var _constants = require("../../constants");
var _navigation = require("../../services/navigation");
var _http = require("../../services/http");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryAdd = ({
  history,
  location: {
    search
  }
}) => {
  const section = 'repositories';
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs('repositoryAdd');
    _navigation.docTitleService.setTitle('repositoryAdd');
  }, []);
  const onSave = async newRepository => {
    setIsSaving(true);
    setSaveError(null);
    const {
      name
    } = newRepository;
    const {
      error
    } = await (0, _http.addRepository)(newRepository);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
    } else {
      const {
        redirect
      } = (0, _queryString.parse)(search.replace(/^\?/, ''), {
        sort: false
      });
      history.push(redirect ? redirect : encodeURI(`${_constants.BASE_PATH}/${encodeURIComponent(section)}/${encodeURIComponent(name)}`));
    }
  };
  const emptyRepository = {
    name: '',
    type: null,
    settings: {}
  };
  const renderSaveError = () => {
    return saveError ? /*#__PURE__*/_react.default.createElement(_shared_imports.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.addRepository.savingRepositoryErrorTitle",
        defaultMessage: "Cannot register new repository"
      }),
      error: saveError,
      "data-test-subj": "saveRepositoryApiError"
    }) : null;
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.addRepositoryTitle",
      defaultMessage: "Register repository"
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_components.RepositoryForm, {
    repository: emptyRepository,
    isSaving: isSaving,
    saveError: renderSaveError(),
    clearSaveError: clearSaveError,
    onSave: onSave
  }));
};
exports.RepositoryAdd = RepositoryAdd;