"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_context = require("../../../../../app_context");
var _components = require("../../../../../components");
var _navigation = require("../../../../../services/navigation");
var _summaries = require("../../../../../components/summaries");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabSummary = ({
  policy
}) => {
  const {
    i18n,
    history
  } = (0, _app_context.useServices)();
  const {
    version,
    name,
    modifiedDateMillis,
    snapshotName,
    repository,
    schedule,
    nextExecutionMillis,
    config,
    stats,
    retention,
    isManagedPolicy
  } = policy;
  const {
    includeGlobalState,
    featureStates,
    ignoreUnavailable,
    indices,
    partial
  } = config || {
    includeGlobalState: undefined,
    featureStates: [],
    ignoreUnavailable: undefined,
    indices: undefined,
    partial: undefined
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyDetails.managedPolicyWarningTitle",
      defaultMessage: "This is a managed policy used by other systems. Any changes you make might affect how these systems operate."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null, stats && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotsTaken,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotsTakenStat', {
      defaultMessage: 'Snapshots taken'
    }),
    titleSize: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotsFailed,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotsFailedStat', {
      defaultMessage: 'Failures'
    }),
    titleSize: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotsDeleted,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotsDeletedStat', {
      defaultMessage: 'Deleted'
    }),
    titleSize: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: stats.snapshotDeletionFailures,
    description: i18n.translate('xpack.snapshotRestore.policyDetails.snapshotDeletionFailuresStat', {
      defaultMessage: 'Deletion failures'
    }),
    titleSize: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.generalTitle",
    defaultMessage: "General"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "version"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.versionLabel",
    defaultMessage: "Version"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, version))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "modified"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.modifiedDateLabel",
    defaultMessage: "Last modified"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
    epochMs: modifiedDateMillis
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "name"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.snapshotNameLabel",
    defaultMessage: "Snapshot name"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToSnapshots)(undefined, name)), snapshotName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "repository"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.repositoryLabel",
    defaultMessage: "Repository"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _public.reactRouterNavigate)(history, (0, _navigation.linkToRepository)(repository)), repository))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "schedule"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.scheduleLabel",
    defaultMessage: "Schedule"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, schedule))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "execution"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.nextExecutionLabel",
    defaultMessage: "Next snapshot"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
    epochMs: nextExecutionMillis
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "indices"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.dataStreamsAndIndicesLabel",
    defaultMessage: "Data streams and indices"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, /*#__PURE__*/_react.default.createElement(_components.CollapsibleIndicesList, {
    indices: indices
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "ignoreUnavailable"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.ignoreUnavailableLabel",
    defaultMessage: "Ignore unavailable indices"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, ignoreUnavailable ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.ignoreUnavailableTrueLabel",
    defaultMessage: "Yes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.ignoreUnavailableFalseLabel",
    defaultMessage: "No"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "includeGlobalState"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.includeGlobalStateLabel",
    defaultMessage: "Include global state"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, includeGlobalState === false ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "withoutGlobalState",
    id: "xpack.snapshotRestore.policyDetails.includeGlobalStateFalseLabel",
    defaultMessage: "No"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    "data-test-subj": "withGlobalStateAndFeatureStates",
    id: "xpack.snapshotRestore.policyDetails.includeGlobalStateTrueLabel",
    defaultMessage: "Yes"
  })))), /*#__PURE__*/_react.default.createElement(_summaries.PolicyFeatureStatesSummary, {
    includeGlobalState: includeGlobalState,
    featureStates: featureStates
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "partial"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.partialLabel",
    defaultMessage: "Allow partial shards"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    className: "eui-textBreakWord",
    "data-test-subj": "value"
  }, partial ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.partialTrueLabel",
    defaultMessage: "Yes"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.partialFalseLabel",
    defaultMessage: "No"
  }))))), retention && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.retentionTitle",
    defaultMessage: "Retention"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, retention.expireAfterValue && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.expireAfterLabel",
    defaultMessage: "Delete after"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, retention.expireAfterValue, retention.expireAfterUnit)), retention.minCount && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.minCountLabel",
    defaultMessage: "Min count"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, retention.minCount)), retention.maxCount && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyDetails.maxCountLabel",
    defaultMessage: "Max count"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, retention.maxCount)))));
};
exports.TabSummary = TabSummary;