"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../../../../common/lib");
var _validation = require("../../services/validation");
var _step_one = require("./step_one");
var _step_two = require("./step_two");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryForm = ({
  repository: originalRepository,
  isManagedRepository,
  isEditing,
  isSaving,
  saveError,
  clearSaveError,
  onSave
}) => {
  const [currentStep, setCurrentStep] = (0, _react.useState)(isEditing ? 2 : 1);

  // Repository state
  const [repository, setRepository] = (0, _react.useState)({
    ...originalRepository,
    settings: {
      ...originalRepository.settings
    }
  });

  // Repository validation state
  const [validation, setValidation] = (0, _react.useState)({
    isValid: true,
    errors: {}
  });
  const updateRepository = updatedFields => {
    const newRepository = {
      ...repository,
      ...updatedFields
    };
    setRepository(newRepository);
  };
  const saveRepository = () => {
    const newValidation = (0, _validation.validateRepository)(repository, true);
    const {
      isValid
    } = newValidation;
    setValidation(newValidation);
    if (isValid) {
      onSave(repository);
    }
  };
  const goToNextStep = () => {
    const newValidation = (0, _validation.validateRepository)(repository, false);
    const {
      isValid
    } = newValidation;
    setValidation(newValidation);
    if (isValid) {
      setCurrentStep(2);
    }
  };
  const goToPreviousStep = () => {
    if (isEditing) {
      return;
    }
    setValidation({
      isValid: true,
      errors: {}
    });
    setCurrentStep(1);
    clearSaveError();
  };
  const hasValidationErrors = !validation.isValid;
  const validationErrors = Object.entries((0, _lib.flatten)(validation.errors)).reduce((acc, [key, value]) => {
    return [...acc, value];
  }, []);
  const renderStepOne = () => /*#__PURE__*/_react.default.createElement(_step_one.RepositoryFormStepOne, {
    repository: repository,
    onNext: () => goToNextStep(),
    updateRepository: updateRepository,
    validation: validation
  });
  const renderStepTwo = () => /*#__PURE__*/_react.default.createElement(_step_two.RepositoryFormStepTwo, {
    repository: repository,
    isManagedRepository: isManagedRepository,
    isEditing: isEditing,
    isSaving: isSaving,
    onSave: saveRepository,
    updateRepository: updateRepository,
    validation: validation,
    saveError: saveError,
    onBack: () => goToPreviousStep()
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: hasValidationErrors,
    error: validationErrors,
    "data-test-subj": "repositoryForm"
  }, currentStep === 1 && !isEditing ? renderStepOne() : renderStepTwo());
};
exports.RepositoryForm = RepositoryForm;
RepositoryForm.defaultProps = {
  isEditing: false,
  isSaving: false
};