"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesAndDataStreamsField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../../../app_context");
var _lib = require("../../../../../lib");
var _data_stream_badge = require("../../../../../data_stream_badge");
var _helpers = require("./helpers");
var _data_streams_and_indices_list_help_text = require("./data_streams_and_indices_list_help_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * In future we may be able to split data streams to its own field, but for now
 * they share an array "indices" in the snapshot lifecycle policy config. See
 * this github issue for progress: https://github.com/elastic/elasticsearch/issues/58474
 */
const IndicesAndDataStreamsField = ({
  isManagedPolicy,
  dataStreams,
  indices,
  policy,
  onUpdate: _onUpdate,
  errors
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    config = {}
  } = policy;
  const indicesAndDataStreams = indices.concat(dataStreams);

  // We assume all indices if the config has no indices entry or if we receive an empty array
  const [isAllIndices, setIsAllIndices] = (0, _react.useState)(config.indices == null || Array.isArray(config.indices) && config.indices.length === 0);
  const onUpdate = data => {
    _onUpdate(data, {
      validateIndicesCount: !isAllIndices
    });
  };
  const [indicesAndDataStreamsSelection, setIndicesAndDataStreamsSelection] = (0, _react.useState)(() => Array.isArray(config.indices) && !isAllIndices ? indicesAndDataStreams.filter(i => config.indices.includes(i)) : [...indicesAndDataStreams]);

  // States for choosing all indices, or a subset, including caching previously chosen subset list
  const [indicesAndDataStreamsOptions, setIndicesAndDataStreamsOptions] = (0, _react.useState)(() => (0, _helpers.mapSelectionToIndicesOptions)({
    selection: indicesAndDataStreamsSelection,
    dataStreams,
    indices,
    allSelected: isAllIndices || typeof config.indices === 'string'
  }));

  // State for using selectable indices list or custom patterns
  const [selectIndicesMode, setSelectIndicesMode] = (0, _react.useState)(() => (0, _helpers.determineListMode)({
    configuredIndices: config.indices,
    dataStreams,
    indices
  }));

  // State for custom patterns
  const [indexPatterns, setIndexPatterns] = (0, _react.useState)(() => typeof config.indices === 'string' ? config.indices.split(',') : Array.isArray(config.indices) && config.indices ? config.indices : []);
  const indicesSwitch = /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.allDataStreamsAndIndicesLabel",
      defaultMessage: "All data streams and indices"
    }),
    checked: isAllIndices,
    disabled: isManagedPolicy,
    "data-test-subj": "allIndicesToggle",
    onChange: e => {
      const isChecked = e.target.checked;
      setIsAllIndices(isChecked);
      if (isChecked) {
        setIndicesAndDataStreamsSelection(indicesAndDataStreams);
        setIndicesAndDataStreamsOptions((0, _helpers.mapSelectionToIndicesOptions)({
          allSelected: isAllIndices || typeof config.indices === 'string',
          dataStreams,
          indices,
          selection: indicesAndDataStreamsSelection
        }));
        onUpdate({
          indices: undefined
        });
      } else {
        _onUpdate({
          indices: selectIndicesMode === 'custom' ? indexPatterns.join(',') : [...(indicesAndDataStreamsSelection || [])]
        }, {
          validateIndicesCount: true
        });
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesTitle",
      defaultMessage: "Data streams and indices"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesDescription",
      defaultMessage: "To back up indices and data streams, manually select them or define index patterns to dynamically match them."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isManagedPolicy ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.indicesTooltip",
      defaultMessage: "Cloud-managed policies require all indices."
    }))
  }, indicesSwitch) : indicesSwitch, isAllIndices ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "snapshotRestore__policyForm__stepSettings__indicesFieldWrapper",
    label: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.selectIndicesLabel",
      defaultMessage: "Select indices and data streams"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setSelectIndicesMode('custom');
        onUpdate({
          indices: indexPatterns.join(',')
        });
      },
      "data-test-subj": "useIndexPatternsButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.indicesToggleCustomLink",
      defaultMessage: "Use index patterns"
    })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.indicesPatternLabel",
      defaultMessage: "Index patterns"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "selectIndicesLink",
      onClick: () => {
        setSelectIndicesMode('list');
        onUpdate({
          indices: indicesAndDataStreamsSelection
        });
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesToggleListLink",
      defaultMessage: "Select data streams and indices"
    })))),
    helpText: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_data_streams_and_indices_list_help_text.DataStreamsAndIndicesListHelpText, {
      onSelectionChange: selection => {
        if (selection === 'all') {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = 'on';
          });
          onUpdate({
            indices: [...indicesAndDataStreams]
          });
          setIndicesAndDataStreamsSelection([...indicesAndDataStreams]);
        } else {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = undefined;
          });
          onUpdate({
            indices: []
          });
          setIndicesAndDataStreamsSelection([]);
        }
      },
      selectedIndicesAndDataStreams: indicesAndDataStreamsSelection,
      indices: indices,
      dataStreams: dataStreams
    }) : null,
    isInvalid: Boolean(errors.indices),
    error: errors.indices
  }, selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    allowExclusions: false,
    "data-test-subj": "indicesAndDataStreamsList",
    options: indicesAndDataStreamsOptions,
    onChange: options => {
      const newSelectedIndices = [];
      options.forEach(({
        label,
        checked
      }) => {
        if (checked === 'on') {
          newSelectedIndices.push(label);
        }
      });
      setIndicesAndDataStreamsOptions(options);
      onUpdate({
        indices: newSelectedIndices
      });
      setIndicesAndDataStreamsSelection(newSelectedIndices);
    },
    searchable: true,
    height: 300
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false
  }, search, list)) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: (0, _lib.orderDataStreamsAndIndices)({
      indices: indices.map(index => ({
        label: index,
        value: {
          isDataStream: false
        }
      })),
      dataStreams: dataStreams.map(dataStream => ({
        label: dataStream,
        value: {
          isDataStream: true
        }
      }))
    }),
    renderOption: ({
      label,
      value
    }) => {
      if (value !== null && value !== void 0 && value.isDataStream) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          responsive: false,
          justifyContent: "spaceBetween",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_data_stream_badge.DataStreamBadge, null)));
      }
      return label;
    },
    placeholder: i18n.translate('xpack.snapshotRestore.policyForm.stepSettings.indicesPatternPlaceholder', {
      defaultMessage: 'Enter index patterns, i.e. logstash-*'
    }),
    selectedOptions: indexPatterns.map(pattern => ({
      label: pattern
    })),
    onCreateOption: pattern => {
      if (!pattern.trim().length) {
        return;
      }
      const newPatterns = [...indexPatterns, pattern];
      setIndexPatterns(newPatterns);
      onUpdate({
        indices: newPatterns.join(',')
      });
    },
    onChange: patterns => {
      const newPatterns = patterns.map(({
        label
      }) => label);
      setIndexPatterns(newPatterns);
      onUpdate({
        indices: newPatterns.join(',')
      });
    }
  }))))));
};
exports.IndicesAndDataStreamsField = IndicesAndDataStreamsField;