"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsibleDataStreamsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_collapsible_list = require("./use_collapsible_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CollapsibleDataStreamsList = ({
  dataStreams
}) => {
  const {
    isShowingFullList,
    setIsShowingFullList,
    items,
    hiddenItemsCount
  } = (0, _use_collapsible_list.useCollapsibleList)({
    items: dataStreams
  });
  return items === 'all' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.dataStreamsList.allDataStreamsValue",
    defaultMessage: "All data streams"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, items.map(dataStream => /*#__PURE__*/_react.default.createElement("div", {
    key: dataStream
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, dataStream))))), hiddenItemsCount ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => isShowingFullList ? setIsShowingFullList(false) : setIsShowingFullList(true)
  }, isShowingFullList ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.dataStreamsList.dataStreamsCollapseAllLink",
    defaultMessage: "Hide {count, plural, one {# data stream} other {# data streams}}",
    values: {
      count: hiddenItemsCount
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.dataStreamsList.dataStreamsExpandAllLink",
    defaultMessage: "Show {count, plural, one {# data stream} other {# data streams}}",
    values: {
      count: hiddenItemsCount
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isShowingFullList ? 'arrowUp' : 'arrowDown'
  }))) : null);
};
exports.CollapsibleDataStreamsList = CollapsibleDataStreamsList;