"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetSLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GetSLO {
  constructor(definitionClient, summaryClient) {
    this.definitionClient = definitionClient;
    this.summaryClient = summaryClient;
  }
  async execute(sloId, spaceId, params = {}) {
    var _params$instanceId;
    const instanceId = (_params$instanceId = params.instanceId) !== null && _params$instanceId !== void 0 ? _params$instanceId : _sloSchema.ALL_VALUE;
    const remoteName = params.remoteName;
    const {
      slo,
      remote
    } = await this.definitionClient.execute(sloId, spaceId, remoteName);
    const {
      summary,
      groupings,
      meta
    } = await this.summaryClient.computeSummary({
      slo,
      instanceId,
      remoteName
    });
    return _sloSchema.getSLOResponseSchema.encode({
      ...slo,
      instanceId,
      summary,
      groupings,
      meta,
      remote
    });
  }
}
exports.GetSLO = GetSLO;