"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sloSettingsObjectId = exports.sloSettings = exports.SO_SLO_SETTINGS_TYPE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SO_SLO_SETTINGS_TYPE = exports.SO_SLO_SETTINGS_TYPE = 'slo-settings';
const sloSettingsObjectId = (space = 'default') => `slo-settings-singleton-${space}`;
exports.sloSettingsObjectId = sloSettingsObjectId;
const sloSettings = exports.sloSettings = {
  name: SO_SLO_SETTINGS_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  modelVersions: {},
  mappings: {
    dynamic: false,
    properties: {}
  },
  management: {
    displayName: _i18n.i18n.translate('xpack.slo.savedObject.sloSettings.displayName', {
      defaultMessage: 'SLO Settings'
    }),
    importableAndExportable: false,
    getTitle(sloSavedObject) {
      return _i18n.i18n.translate('xpack.slo.sloSettings.', {
        defaultMessage: 'SLO Settings [id={id}]',
        values: {
          id: sloSavedObject.id
        }
      });
    }
  }
};