"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBulkDeleteStatusRoute = exports.bulkDeleteSLORoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _uuid = require("uuid");
var _bulk_delete_task = require("../../services/tasks/bulk_delete/bulk_delete_task");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkDeleteSLORoute = exports.bulkDeleteSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/_bulk_delete 2023-10-31',
  options: {
    access: 'public'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.bulkDeleteParamsSchema,
  handler: async ({
    request,
    params,
    plugins
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const taskManager = await plugins.taskManager.start();
    const taskId = (0, _uuid.v4)();
    await taskManager.ensureScheduled({
      id: taskId,
      taskType: _bulk_delete_task.TYPE,
      scope: ['observability', 'slo'],
      state: {},
      runAt: new Date(Date.now() + 3 * 1000),
      params: params.body
    }, {
      request
    });
    return {
      taskId
    };
  }
});
const getBulkDeleteStatusRoute = exports.getBulkDeleteStatusRoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /api/observability/slos/_bulk_delete/{taskId} 2023-10-31',
  options: {
    access: 'public'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.bulkDeleteStatusParamsSchema,
  handler: async ({
    params,
    plugins
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const taskManager = await plugins.taskManager.start();
    const task = await taskManager.get(params.path.taskId).catch(() => undefined);
    if (!task) {
      return {
        isDone: true,
        error: 'Task not found'
      };
    }
    if (!task.state.isDone) {
      return {
        isDone: false,
        results: []
      };
    }
    return {
      isDone: task.state.isDone,
      results: task.state.results,
      error: task.state.error
    };
  }
});