"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBrushTimeBounds = getBrushTimeBounds;
exports.toCalendarAlignedMomentUnitOfTime = toCalendarAlignedMomentUnitOfTime;
exports.toDuration = toDuration;
exports.toMinutes = toMinutes;
var _moment = _interopRequireDefault(require("moment"));
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toDuration(duration) {
  const durationValue = duration.substring(0, duration.length - 1);
  const durationUnit = duration.substring(duration.length - 1);
  return {
    value: parseInt(durationValue, 10),
    unit: durationUnit
  };
}
function toMinutes(duration) {
  switch (duration.unit) {
    case 'm':
      return duration.value;
    case 'h':
      return duration.value * 60;
    case 'd':
      return duration.value * 24 * 60;
    case 'w':
      return duration.value * 7 * 24 * 60;
    case 'M':
      return duration.value * 30 * 24 * 60;
    default:
      (0, _std.assertNever)(duration.unit);
  }
}
function toCalendarAlignedMomentUnitOfTime(unit) {
  switch (unit) {
    default:
    case 'w':
      return 'isoWeek';
    case 'M':
      return 'months';
  }
}
function getBrushTimeBounds(e) {
  var _e$x, _e$x2;
  const from = (0, _moment.default)(Number((_e$x = e.x) === null || _e$x === void 0 ? void 0 : _e$x[0])).toDate();
  const to = (0, _moment.default)(Number((_e$x2 = e.x) === null || _e$x2 === void 0 ? void 0 : _e$x2[1])).toDate();
  return {
    from,
    to
  };
}