"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGroupName = useGroupName;
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _std = require("@kbn/std");
var _constants = require("../../../../slo_edit/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGroupName(groupBy, group, summary) {
  var _summary$worst, _summary$worst$slo, _SLI_OPTIONS$find$tex, _SLI_OPTIONS$find;
  const groupName = group.toLowerCase();
  switch (groupBy) {
    case 'ungrouped':
    case 'slo.tags':
    case 'status':
    case 'slo.id':
      return groupName;
    case 'slo.instanceId':
      if (groupName === _sloSchema.ALL_VALUE || !(summary !== null && summary !== void 0 && (_summary$worst = summary.worst) !== null && _summary$worst !== void 0 && (_summary$worst$slo = _summary$worst.slo) !== null && _summary$worst$slo !== void 0 && _summary$worst$slo.groupings)) {
        return _i18n.i18n.translate('xpack.slo.group.ungroupedInstanceId', {
          defaultMessage: 'Ungrouped'
        });
      }
      const groupNames = flattenObject(summary.worst.slo.groupings);
      return Object.entries(groupNames).map(([key, value]) => `${key}: ${value}`).join(', ');
    case 'slo.indicator.type':
      return (_SLI_OPTIONS$find$tex = (_SLI_OPTIONS$find = _constants.SLI_OPTIONS.find(option => option.value === group)) === null || _SLI_OPTIONS$find === void 0 ? void 0 : _SLI_OPTIONS$find.text) !== null && _SLI_OPTIONS$find$tex !== void 0 ? _SLI_OPTIONS$find$tex : groupName;
    case '_index':
      if (groupName.includes(':.')) {
        const [remoteClusterName] = groupName.split(':.');
        return _i18n.i18n.translate('xpack.slo.group.remoteCluster', {
          defaultMessage: 'Remote Cluster: {remoteClusterName}',
          values: {
            remoteClusterName
          }
        });
      }
      return _i18n.i18n.translate('xpack.slo.group.remoteCluster.localKibana', {
        defaultMessage: 'Local Kibana'
      });
    default:
      (0, _std.assertNever)(groupBy);
  }
}
function flattenObject(obj, parentKey = '', result = {}) {
  for (const key in obj) {
    if (Object.hasOwn(obj, key)) {
      const newKey = parentKey ? `${parentKey}.${key}` : key;
      if (typeof obj[key] === 'object' && obj[key] !== null) {
        flattenObject(obj[key], newKey, result);
      } else {
        result[newKey] = obj[key];
      }
    }
  }
  return result;
}