"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloOutdatedFilterCallout = SloOutdatedFilterCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_url_search_state = require("../hooks/use_url_search_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloOutdatedFilterCallout() {
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  if (!state.includeOutdatedOnly) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info"
  }), ' ', _i18n.i18n.translate('xpack.slo.outdatedSloFilterCallout.title', {
    defaultMessage: "You're currently viewing only outdated SLOs. You can reset them from the action menu to bring them up to date."
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "outdated-filter-help-callout",
    onClick: () => {
      onStateChange({
        ...state,
        includeOutdatedOnly: false
      });
    }
  }, _i18n.i18n.translate('xpack.slo.outdatedSloFilterCallout.action', {
    defaultMessage: 'Remove filter'
  }))));
}