"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMEWINDOW_TYPE_OPTIONS = exports.TIMESLICE_METRIC_DEFAULT_VALUES = exports.SYNTHETICS_AVAILABILITY_DEFAULT_VALUES = exports.SLO_EDIT_FORM_DEFAULT_VALUES_SYNTHETICS_AVAILABILITY = exports.SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = exports.SLO_EDIT_FORM_DEFAULT_VALUES = exports.SLI_OPTIONS = exports.SETTINGS_DEFAULT_VALUES = exports.ROLLING_TIMEWINDOW_OPTIONS = exports.MAX_WIDTH = exports.HISTOGRAM_DEFAULT_VALUES = exports.CUSTOM_METRIC_DEFAULT_VALUES = exports.CUSTOM_KQL_DEFAULT_VALUES = exports.COMPARATOR_OPTIONS = exports.COMPARATOR_MAPPING = exports.COMPARATOR_LTE = exports.COMPARATOR_LT = exports.COMPARATOR_GTE = exports.COMPARATOR_GT = exports.CALENDARALIGNED_TIMEWINDOW_OPTIONS = exports.BUDGETING_METHOD_OPTIONS = exports.APM_LATENCY_DEFAULT_VALUES = exports.APM_AVAILABILITY_DEFAULT_VALUES = void 0;
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _labels = require("../../utils/slo/labels");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_WIDTH = exports.MAX_WIDTH = 900;
const SLI_OPTIONS = exports.SLI_OPTIONS = [{
  value: 'sli.kql.custom',
  text: _labels.INDICATOR_CUSTOM_KQL
}, {
  value: 'sli.metric.custom',
  text: _labels.INDICATOR_CUSTOM_METRIC
}, {
  value: 'sli.metric.timeslice',
  text: _labels.INDICATOR_TIMESLICE_METRIC
}, {
  value: 'sli.histogram.custom',
  text: _labels.INDICATOR_HISTOGRAM
}, {
  value: 'sli.apm.transactionDuration',
  text: _labels.INDICATOR_APM_LATENCY
}, {
  value: 'sli.apm.transactionErrorRate',
  text: _labels.INDICATOR_APM_AVAILABILITY
}, {
  value: 'sli.synthetics.availability',
  text: _labels.INDICATOR_SYNTHETICS_AVAILABILITY
}];
const BUDGETING_METHOD_OPTIONS = exports.BUDGETING_METHOD_OPTIONS = [{
  value: 'occurrences',
  text: _labels.BUDGETING_METHOD_OCCURRENCES
}, {
  value: 'timeslices',
  text: _labels.BUDGETING_METHOD_TIMESLICES
}];
const TIMEWINDOW_TYPE_OPTIONS = exports.TIMEWINDOW_TYPE_OPTIONS = [{
  value: 'rolling',
  text: _i18n.i18n.translate('xpack.slo.sloEdit.timeWindow.rolling', {
    defaultMessage: 'Rolling'
  })
}, {
  value: 'calendarAligned',
  text: _i18n.i18n.translate('xpack.slo.sloEdit.timeWindow.calendarAligned', {
    defaultMessage: 'Calendar aligned'
  })
}];
const CALENDARALIGNED_TIMEWINDOW_OPTIONS = exports.CALENDARALIGNED_TIMEWINDOW_OPTIONS = [{
  value: '1w',
  text: _i18n.i18n.translate('xpack.slo.sloEdit.calendarTimeWindow.weekly', {
    defaultMessage: 'Weekly'
  })
}, {
  value: '1M',
  text: _i18n.i18n.translate('xpack.slo.sloEdit.calendarTimeWindow.monthly', {
    defaultMessage: 'Monthly'
  })
}];
const ROLLING_TIMEWINDOW_OPTIONS = exports.ROLLING_TIMEWINDOW_OPTIONS = [90, 30, 7].map(number => ({
  value: `${number}d`,
  text: _i18n.i18n.translate('xpack.slo.sloEdit.rollingTimeWindow.days', {
    defaultMessage: '{number} days',
    values: {
      number
    }
  })
}));
const CUSTOM_KQL_DEFAULT_VALUES = exports.CUSTOM_KQL_DEFAULT_VALUES = {
  type: 'sli.kql.custom',
  params: {
    index: '',
    filter: '',
    good: '',
    total: '',
    timestampField: ''
  }
};
const CUSTOM_METRIC_DEFAULT_VALUES = exports.CUSTOM_METRIC_DEFAULT_VALUES = {
  type: 'sli.metric.custom',
  params: {
    index: '',
    filter: '',
    good: {
      metrics: [{
        name: 'A',
        aggregation: 'sum',
        field: ''
      }],
      equation: 'A'
    },
    total: {
      metrics: [{
        name: 'A',
        aggregation: 'sum',
        field: ''
      }],
      equation: 'A'
    },
    timestampField: ''
  }
};
const TIMESLICE_METRIC_DEFAULT_VALUES = exports.TIMESLICE_METRIC_DEFAULT_VALUES = {
  type: 'sli.metric.timeslice',
  params: {
    index: '',
    filter: '',
    metric: {
      metrics: [{
        name: 'A',
        aggregation: 'avg',
        field: ''
      }],
      equation: 'A',
      comparator: 'GT',
      threshold: 0
    },
    timestampField: ''
  }
};
const HISTOGRAM_DEFAULT_VALUES = exports.HISTOGRAM_DEFAULT_VALUES = {
  type: 'sli.histogram.custom',
  params: {
    index: '',
    timestampField: '',
    filter: '',
    good: {
      field: '',
      aggregation: 'value_count'
    },
    total: {
      field: '',
      aggregation: 'value_count'
    }
  }
};
const APM_LATENCY_DEFAULT_VALUES = exports.APM_LATENCY_DEFAULT_VALUES = {
  type: 'sli.apm.transactionDuration',
  params: {
    service: '',
    environment: '',
    transactionType: '',
    transactionName: '',
    threshold: 250,
    filter: '',
    index: ''
  }
};
const APM_AVAILABILITY_DEFAULT_VALUES = exports.APM_AVAILABILITY_DEFAULT_VALUES = {
  type: 'sli.apm.transactionErrorRate',
  params: {
    service: '',
    environment: '',
    transactionType: '',
    transactionName: '',
    filter: '',
    index: ''
  }
};
const SYNTHETICS_AVAILABILITY_DEFAULT_VALUES = exports.SYNTHETICS_AVAILABILITY_DEFAULT_VALUES = {
  type: 'sli.synthetics.availability',
  params: {
    projects: [],
    tags: [],
    monitorIds: [],
    index: _constants.SYNTHETICS_INDEX_PATTERN
  }
};
const SETTINGS_DEFAULT_VALUES = exports.SETTINGS_DEFAULT_VALUES = {
  frequency: 1,
  preventInitialBackfill: false,
  syncDelay: 1,
  syncField: null
};
const SLO_EDIT_FORM_DEFAULT_VALUES = exports.SLO_EDIT_FORM_DEFAULT_VALUES = {
  name: '',
  description: '',
  indicator: CUSTOM_KQL_DEFAULT_VALUES,
  timeWindow: {
    duration: ROLLING_TIMEWINDOW_OPTIONS[1].value,
    type: 'rolling'
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  },
  groupBy: _sloSchema.ALL_VALUE,
  settings: SETTINGS_DEFAULT_VALUES
};
const SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = exports.SLO_EDIT_FORM_DEFAULT_VALUES_CUSTOM_METRIC = {
  name: '',
  description: '',
  indicator: CUSTOM_METRIC_DEFAULT_VALUES,
  timeWindow: {
    duration: ROLLING_TIMEWINDOW_OPTIONS[1].value,
    type: 'rolling'
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  },
  groupBy: _sloSchema.ALL_VALUE,
  settings: SETTINGS_DEFAULT_VALUES
};
const SLO_EDIT_FORM_DEFAULT_VALUES_SYNTHETICS_AVAILABILITY = exports.SLO_EDIT_FORM_DEFAULT_VALUES_SYNTHETICS_AVAILABILITY = {
  name: '',
  description: '',
  indicator: SYNTHETICS_AVAILABILITY_DEFAULT_VALUES,
  timeWindow: {
    duration: ROLLING_TIMEWINDOW_OPTIONS[1].value,
    type: 'rolling'
  },
  tags: [],
  budgetingMethod: BUDGETING_METHOD_OPTIONS[0].value,
  objective: {
    target: 99
  },
  groupBy: _constants.SYNTHETICS_DEFAULT_GROUPINGS,
  settings: SETTINGS_DEFAULT_VALUES
};
const COMPARATOR_GT = exports.COMPARATOR_GT = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.gtLabel', {
  defaultMessage: 'Greater than'
});
const COMPARATOR_GTE = exports.COMPARATOR_GTE = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.gteLabel', {
  defaultMessage: 'Greater than or equal to'
});
const COMPARATOR_LT = exports.COMPARATOR_LT = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.ltLabel', {
  defaultMessage: 'Less than'
});
const COMPARATOR_LTE = exports.COMPARATOR_LTE = _i18n.i18n.translate('xpack.slo.sloEdit.sliType.timesliceMetric.lteLabel', {
  defaultMessage: 'Less than or equal to'
});
const COMPARATOR_MAPPING = exports.COMPARATOR_MAPPING = {
  GT: COMPARATOR_GT,
  GTE: COMPARATOR_GTE,
  LT: COMPARATOR_LT,
  LTE: COMPARATOR_LTE
};
const COMPARATOR_OPTIONS = exports.COMPARATOR_OPTIONS = [{
  text: COMPARATOR_GT,
  value: 'GT'
}, {
  text: COMPARATOR_GTE,
  value: 'GTE'
}, {
  text: COMPARATOR_LT,
  value: 'LT'
}, {
  text: COMPARATOR_LTE,
  value: 'LTE'
}];