"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexAndTimestampField = IndexAndTimestampField;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _timestamp_field_selector = require("../../common/timestamp_field_selector");
var _index_selection = require("./index_selection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexAndTimestampField({
  dataView,
  isLoading
}) {
  var _dataView$fields$filt, _dataView$fields;
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const timestampFields = (_dataView$fields$filt = dataView === null || dataView === void 0 ? void 0 : (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : _dataView$fields.filter(field => field.type === 'date')) !== null && _dataView$fields$filt !== void 0 ? _dataView$fields$filt : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    css: {
      paddingRight: 34
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_index_selection.IndexSelection, {
    selectedDataView: dataView
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_timestamp_field_selector.TimestampFieldSelector, {
    fields: timestampFields,
    isLoading: !!index && isLoading,
    isDisabled: !index
  })));
}