"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApmDefaultValues = void 0;
var _reactHookForm = require("react-hook-form");
var _sloSchema = require("@kbn/slo-schema");
var _react = require("react");
var _use_fetch_apm_indices = require("../../../../../hooks/use_fetch_apm_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useApmDefaultValues = () => {
  const {
    watch,
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const {
    data: apmIndex
  } = (0, _use_fetch_apm_indices.useFetchApmIndex)();
  const [serviceName = '', environment = '', transactionType = '', transactionName = ''] = watch(['indicator.params.service', 'indicator.params.environment', 'indicator.params.transactionType', 'indicator.params.transactionName']);
  (0, _react.useEffect)(() => {
    if (apmIndex !== '') {
      setValue('indicator.params.index', apmIndex);
    }
  }, [setValue, apmIndex]);
  (0, _react.useEffect)(() => {
    if (serviceName) {
      if (!environment) {
        setValue('indicator.params.environment', _sloSchema.ALL_VALUE);
      }
      if (!transactionType) {
        setValue('indicator.params.transactionType', _sloSchema.ALL_VALUE);
      }
      if (!transactionName) {
        setValue('indicator.params.transactionName', _sloSchema.ALL_VALUE);
      }
    }
  }, [environment, serviceName, setValue, transactionName, transactionType]);
};
exports.useApmDefaultValues = useApmDefaultValues;