"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncFieldSelector = SyncFieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_create_data_view = require("../../../../../hooks/use_create_data_view");
var _create_options = require("../../../helpers/create_options");
var _optional_text = require("../../common/optional_text");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const placeholder = _i18n.i18n.translate('xpack.slo.sloEdit.settings.syncField.placeholder', {
  defaultMessage: 'Select a timestamp field'
});
function SyncFieldSelector() {
  var _dataView$fields$filt, _dataView$fields;
  const {
    control,
    watch,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [index, dataViewId] = watch(['indicator.params.index', 'indicator.params.dataViewId']);
  const {
    dataView,
    loading: isIndexFieldsLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index,
    dataViewId
  });
  const timestampFields = (_dataView$fields$filt = dataView === null || dataView === void 0 ? void 0 : (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : _dataView$fields.filter(field => field.type === 'date')) !== null && _dataView$fields$filt !== void 0 ? _dataView$fields$filt : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.settings.syncField.label', {
      defaultMessage: 'Sync field'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.settings.syncField.tooltip', {
        defaultMessage: 'The date field that is used to identify new documents in the source. It is strongly recommended to use a field that contains the ingest timestamp. If you use a different field, you might need to set the delay such that it accounts for data transmission delays. When unspecified, we use the indicator timestamp field.'
      }),
      position: "top"
    })),
    isInvalid: getFieldState('settings.syncField').invalid,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, null)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: 'settings.syncField',
    defaultValue: null,
    control: control,
    rules: {
      required: false
    },
    render: ({
      field,
      fieldState
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        placeholder: placeholder,
        "aria-label": placeholder,
        isClearable: true,
        isDisabled: isIndexFieldsLoading,
        isInvalid: fieldState.invalid,
        isLoading: isIndexFieldsLoading,
        onChange: selected => {
          if (selected.length) {
            return field.onChange(selected[0].value);
          }
          field.onChange(null);
        },
        singleSelection: {
          asPlainText: true
        },
        options: (0, _create_options.createOptionsFromFields)(timestampFields),
        selectedOptions: !!timestampFields && !!field.value ? [{
          value: field.value,
          label: field.value
        }] : []
      }));
    }
  }));
}